package com.gingersoft.gsa.cloud.table.mvp.model;

import android.app.Application;

import com.gingersoft.gsa.cloud.common.bean.BaseResult;
import com.gingersoft.gsa.cloud.common.rxjava.MyRxSchedulerUtils;
import com.gingersoft.gsa.cloud.common.rxjava.MyRxUtils;
import com.gingersoft.gsa.cloud.database.bean.ComboItem;
import com.gingersoft.gsa.cloud.database.bean.Food;
import com.gingersoft.gsa.cloud.database.bean.FoodCombo;
import com.gingersoft.gsa.cloud.database.bean.FoodModifier;
import com.gingersoft.gsa.cloud.database.bean.Modifier;
import com.gingersoft.gsa.cloud.database.utils.ComboItemDaoUtils;
import com.gingersoft.gsa.cloud.database.utils.FoodComboDaoUtils;
import com.gingersoft.gsa.cloud.database.utils.FoodDaoUtils;
import com.gingersoft.gsa.cloud.database.utils.ModifierDaoUtils;
import com.gingersoft.gsa.cloud.table.mvp.model.service.MealService;
import com.gingersoft.gsa.cloud.table.mvp.model.utils.MealConditionFilterUtils;
import com.gingersoft.gsa.cloud.table.mvp.model.utils.MealStyleUtils;
import com.google.gson.Gson;
import com.jess.arms.di.scope.ActivityScope;
import com.jess.arms.integration.IRepositoryManager;
import com.jess.arms.mvp.BaseModel;

import com.jess.arms.di.scope.FragmentScope;

import javax.inject.Inject;

import com.gingersoft.gsa.cloud.table.mvp.contract.MealStandContract;

import java.util.List;

import io.reactivex.Observable;
import io.reactivex.Single;
import okhttp3.RequestBody;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 04/17/2021 10:40
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@ActivityScope
public class MealStandModel extends BaseMealModel implements MealStandContract.Model {
    @Inject
    Gson mGson;
    @Inject
    Application mApplication;

    @Inject
    public MealStandModel(IRepositoryManager repositoryManager) {
        super(repositoryManager);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mGson = null;
        this.mApplication = null;
    }

    @Override
    public Single<BaseResult> getCurrentSoldoutFood(RequestBody requestBody) {
        return mRepositoryManager.obtainRetrofitService(MealService.class)
                .getCurrentSoldoutFood(requestBody)
                .compose(MyRxSchedulerUtils._io_main_f());
    }

    @Override
    public Single<BaseResult> createOrder(RequestBody requestBody) {
        return mRepositoryManager.obtainRetrofitService(MealService.class)
                .createOrder(requestBody)
                .compose(MyRxSchedulerUtils._io_main_f());
    }

    @Override
    public Single<BaseResult> addOrderFood(RequestBody requestBody) {
        return mRepositoryManager.obtainRetrofitService(MealService.class)
                .addOrderFood(requestBody)
                .compose(MyRxSchedulerUtils._io_main_f());
    }

    @Override
    public Single<BaseResult> getRestaurantFoodReason(int brandId, int restaurantId, int type) {
        return mRepositoryManager.obtainRetrofitService(MealService.class)
                .getRestaurantFoodReason(brandId, restaurantId, type)
                .compose(MyRxSchedulerUtils._io_main_f());
    }

    @Override
    public List<Food> queryDB_FoodGroupList(int foodSummary) {
        FoodDaoUtils foodDaoUtils = new FoodDaoUtils(mApplication);
        return MealStyleUtils.assemblyFoodsColor(
                        MealConditionFilterUtils.foodConditionFilter(
                                foodDaoUtils.queryFoodGroupByQueryBuilder(foodSummary), foodSummary));
    }

    @Override
    public List<Food> queryDB_FoodList(long parentId, int foodSummary) {
        FoodDaoUtils foodDaoUtils = new FoodDaoUtils(mApplication);
        return MealStyleUtils.assemblyFoodsColor(
                        MealConditionFilterUtils.foodConditionFilter(
                                foodDaoUtils.queryFoodByQueryBuilder(parentId, foodSummary), foodSummary));
    }

    @Override
    public Food queryFoodByFlu(String plu) {
        FoodDaoUtils foodDaoUtils = new FoodDaoUtils(mApplication);
        final Food food = foodDaoUtils.queryFoodByQueryBuilder(plu);
        return food;
    }

    @Override
    public List<Modifier> queryDB_ModifierList(long fid, int mode) {
        ModifierDaoUtils daoUtils = new ModifierDaoUtils(mApplication);
        return MealStyleUtils.assemblyModifiersColor(daoUtils.queryModifiersByFid(fid, mode));
    }

    @Override
    public List<ComboItem> queryDB_ComboList(long fid, int foodSummary) {
        ComboItemDaoUtils comboItemDao = new ComboItemDaoUtils(mApplication);
        return MealConditionFilterUtils.comboConditionFilter(
                comboItemDao.queryComboItemsByFidQueryBuilder(fid, foodSummary), foodSummary);
    }

    @Override
    public List<FoodCombo> isComboFood(long fid) {
        FoodComboDaoUtils foodComboDaoUtils = new FoodComboDaoUtils(mApplication);
        return foodComboDaoUtils.queryCombosFoodsByQueryBuilder(fid);
    }


}