package com.gingersoft.gsa.cloud.table.mvp.ui.adapter;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.widget.Button;

import com.gingersoft.gsa.cloud.database.bean.Function;
import com.gingersoft.gsa.cloud.table.R;
import com.gingersoft.gsa.cloud.table.R2;
import com.jess.arms.base.BaseHolder;
import com.jess.arms.base.DefaultAdapter;

import java.util.List;

import butterknife.BindView;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2018/6/27
 * 修订历史：2018/6/27
 * 描述：
 */

public class MealBillFunctionAdapter extends DefaultAdapter<Function> {


    public MealBillFunctionAdapter(Context context, List<Function> infos) {
        super(infos);
    }

    @Override
    public int getItemCount() {
        return mInfos.size();
    }

    @Override
    public BaseHolder<Function> getHolder(View v, int viewType) {
        return new TopFunctionItemHolder(v);
    }

    @Override
    public int getLayoutId(int viewType) {
        return R.layout.meal_bill_top_function;
    }

    class TopFunctionItemHolder extends BaseHolder<Function> {

        @BindView(R2.id.btn_name)
        Button btn_name;
        @BindView(R2.id.btn_lable)
        Button btn_lable;

        public TopFunctionItemHolder(View itemView) {
            super(itemView);
        }

        @Override
        public void setData(Function datasBean, int position) {

            btn_name.setText(datasBean.getResName());
            btn_name.setTextColor(datasBean.getTextColor());
            btn_name.setBackgroundColor(datasBean.getBackgroundColor());
            btn_name.setTextSize(datasBean.getTextSize());

            if (!TextUtils.isEmpty(datasBean.getLable())) {
                btn_lable.setText(datasBean.getLable());
                btn_lable.setVisibility(View.VISIBLE);
            } else {
                btn_lable.setVisibility(View.INVISIBLE);
            }

            btn_name.setOnClickListener(v -> {
//                    RxBindingUtils.setViewClicks(v)
//                            .subscribe(new Consumer<Object>() {
//
//                                @Override
//                                public void accept(Object o) throws Exception {
                if (onClickListener != null) {
                    onClickListener.onItemClick(v, datasBean);
                }
//                                }
//                            });
            });
            btn_name.setOnLongClickListener(v -> {
                if (onClickListener != null) {
                    onClickListener.onItemLongClick(v, datasBean);
                }
                return false;
            });
        }
    }

    private OnClickListener onClickListener;

    public void setOnClickListener(OnClickListener onClickListener) {
        this.onClickListener = onClickListener;
    }

    public interface OnClickListener {

        void onItemClick(View v, Function function);

        boolean onItemLongClick(View v, Function function);

    }
}
