package com.gingersoft.gsa.cloud.database.greendao;

import android.database.Cursor;
import android.database.sqlite.SQLiteStatement;

import org.greenrobot.greendao.AbstractDao;
import org.greenrobot.greendao.Property;
import org.greenrobot.greendao.internal.DaoConfig;
import org.greenrobot.greendao.database.Database;
import org.greenrobot.greendao.database.DatabaseStatement;

import com.gingersoft.gsa.cloud.database.bean.Food;

// THIS CODE IS GENERATED BY greenDAO, DO NOT EDIT.
/** 
 * DAO for table "FOOD".
*/
public class FoodDao extends AbstractDao<Food, Long> {

    public static final String TABLENAME = "FOOD";

    /**
     * Properties of entity Food.<br/>
     * Can be used for QueryBuilder and for referencing column names.
     */
    public static class Properties {
        public final static Property Id = new Property(0, Long.class, "id", true, "_id");
        public final static Property OrderId = new Property(1, long.class, "orderId", false, "ORDER_ID");
        public final static Property ParentId = new Property(2, int.class, "parentId", false, "PARENT_ID");
        public final static Property FoodName = new Property(3, String.class, "foodName", false, "FOOD_NAME");
        public final static Property RestaurantId = new Property(4, int.class, "restaurantId", false, "RESTAURANT_ID");
        public final static Property Price = new Property(5, double.class, "price", false, "PRICE");
        public final static Property TotalSold = new Property(6, int.class, "totalSold", false, "TOTAL_SOLD");
        public final static Property IsSold = new Property(7, int.class, "isSold", false, "IS_SOLD");
        public final static Property Plu = new Property(8, String.class, "plu", false, "PLU");
        public final static Property LunchboxPrice = new Property(9, double.class, "lunchboxPrice", false, "LUNCHBOX_PRICE");
    }


    public FoodDao(DaoConfig config) {
        super(config);
    }
    
    public FoodDao(DaoConfig config, DaoSession daoSession) {
        super(config, daoSession);
    }

    /** Creates the underlying database table. */
    public static void createTable(Database db, boolean ifNotExists) {
        String constraint = ifNotExists? "IF NOT EXISTS ": "";
        db.execSQL("CREATE TABLE " + constraint + "\"FOOD\" (" + //
                "\"_id\" INTEGER PRIMARY KEY AUTOINCREMENT ," + // 0: id
                "\"ORDER_ID\" INTEGER NOT NULL ," + // 1: orderId
                "\"PARENT_ID\" INTEGER NOT NULL ," + // 2: parentId
                "\"FOOD_NAME\" TEXT," + // 3: foodName
                "\"RESTAURANT_ID\" INTEGER NOT NULL ," + // 4: restaurantId
                "\"PRICE\" REAL NOT NULL ," + // 5: price
                "\"TOTAL_SOLD\" INTEGER NOT NULL ," + // 6: totalSold
                "\"IS_SOLD\" INTEGER NOT NULL ," + // 7: isSold
                "\"PLU\" TEXT," + // 8: plu
                "\"LUNCHBOX_PRICE\" REAL NOT NULL );"); // 9: lunchboxPrice
    }

    /** Drops the underlying database table. */
    public static void dropTable(Database db, boolean ifExists) {
        String sql = "DROP TABLE " + (ifExists ? "IF EXISTS " : "") + "\"FOOD\"";
        db.execSQL(sql);
    }

    @Override
    protected final void bindValues(DatabaseStatement stmt, Food entity) {
        stmt.clearBindings();
 
        Long id = entity.getId();
        if (id != null) {
            stmt.bindLong(1, id);
        }
        stmt.bindLong(2, entity.getOrderId());
        stmt.bindLong(3, entity.getParentId());
 
        String foodName = entity.getFoodName();
        if (foodName != null) {
            stmt.bindString(4, foodName);
        }
        stmt.bindLong(5, entity.getRestaurantId());
        stmt.bindDouble(6, entity.getPrice());
        stmt.bindLong(7, entity.getTotalSold());
        stmt.bindLong(8, entity.getIsSold());
 
        String plu = entity.getPlu();
        if (plu != null) {
            stmt.bindString(9, plu);
        }
        stmt.bindDouble(10, entity.getLunchboxPrice());
    }

    @Override
    protected final void bindValues(SQLiteStatement stmt, Food entity) {
        stmt.clearBindings();
 
        Long id = entity.getId();
        if (id != null) {
            stmt.bindLong(1, id);
        }
        stmt.bindLong(2, entity.getOrderId());
        stmt.bindLong(3, entity.getParentId());
 
        String foodName = entity.getFoodName();
        if (foodName != null) {
            stmt.bindString(4, foodName);
        }
        stmt.bindLong(5, entity.getRestaurantId());
        stmt.bindDouble(6, entity.getPrice());
        stmt.bindLong(7, entity.getTotalSold());
        stmt.bindLong(8, entity.getIsSold());
 
        String plu = entity.getPlu();
        if (plu != null) {
            stmt.bindString(9, plu);
        }
        stmt.bindDouble(10, entity.getLunchboxPrice());
    }

    @Override
    public Long readKey(Cursor cursor, int offset) {
        return cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0);
    }    

    @Override
    public Food readEntity(Cursor cursor, int offset) {
        Food entity = new Food( //
            cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0), // id
            cursor.getLong(offset + 1), // orderId
            cursor.getInt(offset + 2), // parentId
            cursor.isNull(offset + 3) ? null : cursor.getString(offset + 3), // foodName
            cursor.getInt(offset + 4), // restaurantId
            cursor.getDouble(offset + 5), // price
            cursor.getInt(offset + 6), // totalSold
            cursor.getInt(offset + 7), // isSold
            cursor.isNull(offset + 8) ? null : cursor.getString(offset + 8), // plu
            cursor.getDouble(offset + 9) // lunchboxPrice
        );
        return entity;
    }
     
    @Override
    public void readEntity(Cursor cursor, Food entity, int offset) {
        entity.setId(cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0));
        entity.setOrderId(cursor.getLong(offset + 1));
        entity.setParentId(cursor.getInt(offset + 2));
        entity.setFoodName(cursor.isNull(offset + 3) ? null : cursor.getString(offset + 3));
        entity.setRestaurantId(cursor.getInt(offset + 4));
        entity.setPrice(cursor.getDouble(offset + 5));
        entity.setTotalSold(cursor.getInt(offset + 6));
        entity.setIsSold(cursor.getInt(offset + 7));
        entity.setPlu(cursor.isNull(offset + 8) ? null : cursor.getString(offset + 8));
        entity.setLunchboxPrice(cursor.getDouble(offset + 9));
     }
    
    @Override
    protected final Long updateKeyAfterInsert(Food entity, long rowId) {
        entity.setId(rowId);
        return rowId;
    }
    
    @Override
    public Long getKey(Food entity) {
        if(entity != null) {
            return entity.getId();
        } else {
            return null;
        }
    }

    @Override
    public boolean hasKey(Food entity) {
        return entity.getId() != null;
    }

    @Override
    protected final boolean isEntityUpdateable() {
        return true;
    }
    
}
