package com.gingersoft.gsa.cloud.base.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.gingersoft.gsa.cloud.base.R;
import com.gingersoft.gsa.cloud.base.adapter.print.BillAdapter;
import com.gingersoft.gsa.cloud.base.adapter.print.BillTypeAdapter;
import com.gingersoft.gsa.cloud.base.adapter.print.FoodAdapter;
import com.gingersoft.gsa.cloud.base.common.bean.BillingBean;
import com.gingersoft.gsa.cloud.base.common.bean.TableBean;
import com.gingersoft.gsa.cloud.base.common.bean.mealManage.MyOrderManage;
import com.gingersoft.gsa.cloud.base.common.bean.mealManage.OpenTableContract;
import com.gingersoft.gsa.cloud.base.utils.time.TimeUtils;
import com.gingersoft.gsa.cloud.base.utils.view.ImageUtils;
import com.gingersoft.gsa.cloud.base.utils.view.LayoutToBitmapUtils;
import com.gingersoft.gsa.cloud.database.bean.Food;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

/**
 * Created by Wyh on 2020/2/10.
 * 打印工具類
 */
public class PrintUtils {

    public static Bitmap getPrintBitmap(Context context) {
        return getPrintBitmap(context, MyOrderManage.getInstance().getOrderFoodList());
    }
    /**
     * 獲取"印單"圖片
     *
     * @param context
     * @return
     */
    public static Bitmap getPrintBitmap(Context context, List<Food> foodList) {
        View view = LinearLayout.inflate(context, R.layout.print_layout_print, null);
        TextView brandName = view.findViewById(R.id.tv_brand_name);
        TextView restaurantName = view.findViewById(R.id.tv_restaurant_name);
        TextView tableNum = view.findViewById(R.id.tv_dining_table_number);
        TextView people = view.findViewById(R.id.tv_people);
        TextView orderNum = view.findViewById(R.id.tv_order_num);
        TextView orderData = view.findViewById(R.id.tv_date);
        RecyclerView rvFood = view.findViewById(R.id.rv_food);
        RecyclerView rvBillAmount = view.findViewById(R.id.rv_bill_amount);
        TextView mTvTotalAmount = view.findViewById(R.id.tv_total_amount);
        TextView checkOutTime = view.findViewById(R.id.tv_checkout_time);
        TextView line_food_info = view.findViewById(R.id.line_food_info);
//        List<Food> foodList = MyOrderManage.getInstance().getOrderFoodList();
        TableBean.DataBean tableBean = OpenTableContract.getDefault().getTableBean();

        tableNum.setText(tableBean.getTableName());
        people.setText(tableBean.getPeopleNumber() + "");
        orderData.setText(tableBean.getCreateTime());

        checkOutTime.setText(TimeUtils.getCurrentTimeInString(TimeUtils.DEFAULT_DATE_FORMAT));

        FoodAdapter foodAdapter = new FoodAdapter(foodList);
        rvFood.setLayoutManager(new LinearLayoutManager(context));
        rvFood.setAdapter(foodAdapter);

        List<BillingBean> billingBeans = new ArrayList<>();
//        billingBeans.add(new BillingBean("合計", 58.88));
//        billingBeans.add(new BillingBean("10%服務費", 5.08));
//        billingBeans.add(new BillingBean("賬單小數", -0.06));
        if (billingBeans.size() <= 0) {
            line_food_info.setVisibility(View.GONE);
        } else {
            BillAdapter billAdapter = new BillAdapter(billingBeans);
            rvBillAmount.setLayoutManager(new LinearLayoutManager(context));
            rvBillAmount.setAdapter(billAdapter);
        }
        if (OpenTableContract.getDefault().

                getTableBean() != null) {
            tableNum.setText(OpenTableContract.getDefault().getTableBean().getTableName());
            people.setText(OpenTableContract.getDefault().getTableBean().getPeopleNumber() + "");
        }

        if (MyOrderManage.getInstance().

                getOrderId() != -1) {
            orderNum.setText(MyOrderManage.getInstance().getOrderId() + "");
        }

        BigDecimal totalAmount = new BigDecimal(0);
        for (
                Food food : MyOrderManage.getInstance().

                getOrderFoodList()) {
            totalAmount = MoneyUtil.sum(totalAmount, MoneyUtil.priceCalculation(food.getPrice(), food.getNumber()));
        }
        //總金額
        mTvTotalAmount.setText(totalAmount + "");

        //加载条形码
//        ImageView ivBarCode = view.findViewById(R.id.iv_bar_code);
//        ivBarCode.setImageBitmap(BitmapUtil.generateBitmap("12312112131", 2, 450, 150));
        LayoutToBitmapUtils.layoutView(context, view);//先测量view
        //580為程序支持的打印紙最大寬度
        return ImageUtils.zoomDrawable(LayoutToBitmapUtils.loadBitmapFromView(view), 580);//将view轉bitmap
    }

    /**
     * 獲取"結賬單"圖片
     *
     * @param context
     * @return
     */
    public static Bitmap getPrintBillBitmap(Context context) {
        View view = LinearLayout.inflate(context, R.layout.print_layout_print_bill, null);
        TextView brandName = view.findViewById(R.id.tv_brand_name);
        TextView restaurantName = view.findViewById(R.id.tv_restaurant_name);
        TextView topOrderNum = view.findViewById(R.id.tv_print_bill_order_num);//頂部的訂單號
        TextView tableNum = view.findViewById(R.id.tv_dining_table_number);
        TextView people = view.findViewById(R.id.tv_people);
        TextView orderNum = view.findViewById(R.id.tv_order_num);
        TextView orderData = view.findViewById(R.id.tv_date);
        RecyclerView rvFood = view.findViewById(R.id.rv_food);
        RecyclerView rvBillAmount = view.findViewById(R.id.rv_bill_amount);
        TextView mTvTotalAmount = view.findViewById(R.id.tv_total_amount);
        TextView checkOutTime = view.findViewById(R.id.tv_checkout_time);
        TextView line_food_info = view.findViewById(R.id.line_food_info);
        RecyclerView rvPayType = view.findViewById(R.id.rv_print_pay_type);//顯示支付方式

        List<Food> foodList = MyOrderManage.getInstance().getOrderFoodList();
        TableBean.DataBean tableBean = OpenTableContract.getDefault().getTableBean();

        tableNum.setText(tableBean.getTableName());
        people.setText(tableBean.getPeopleNumber() + "");
        orderData.setText(tableBean.getCreateTime());

        checkOutTime.setText(TimeUtils.getCurrentTimeInString(TimeUtils.DEFAULT_DATE_FORMAT));

        FoodAdapter foodAdapter = new FoodAdapter(foodList);
        rvFood.setLayoutManager(new LinearLayoutManager(context));
        rvFood.setAdapter(foodAdapter);

        List<BillingBean> billingBeans = new ArrayList<>();
//        billingBeans.add(new BillingBean("合計", 58.88));
//        billingBeans.add(new BillingBean("10%服務費", 5.08));
//        billingBeans.add(new BillingBean("賬單小數", -0.06));
        if (billingBeans.size() <= 0) {
            line_food_info.setVisibility(View.GONE);
        } else {
            BillAdapter billAdapter = new BillAdapter(billingBeans);
            rvBillAmount.setLayoutManager(new LinearLayoutManager(context));
            rvBillAmount.setAdapter(billAdapter);
        }
        if (OpenTableContract.getDefault().getTableBean() != null) {
            tableNum.setText(OpenTableContract.getDefault().getTableBean().getTableName());
            people.setText(OpenTableContract.getDefault().getTableBean().getPeopleNumber() + "");
        }

        if (MyOrderManage.getInstance().getOrderId() != -1) {
            orderNum.setText(MyOrderManage.getInstance().getOrderId() + "");
        }

        BigDecimal totalAmount = new BigDecimal(0);
        for (Food food : MyOrderManage.getInstance().getOrderFoodList()) {
            totalAmount = MoneyUtil.sum(totalAmount, MoneyUtil.priceCalculation(food.getPrice(), food.getNumber()));
        }
        //總金額
        mTvTotalAmount.setText(totalAmount + "");

        rvPayType.setLayoutManager(new LinearLayoutManager(context));
        rvPayType.setAdapter(new BillTypeAdapter(MyOrderManage.getInstance().getBillMoney()));
        //加载条形码
//        ImageView ivBarCode = view.findViewById(R.id.iv_bar_code);
//        ivBarCode.setImageBitmap(BitmapUtil.generateBitmap("12312112131", 2, 450, 150));
        LayoutToBitmapUtils.layoutView(context, view);//先测量view
        //580為程序支持的打印紙最大寬度
        return ImageUtils.zoomDrawable(LayoutToBitmapUtils.loadBitmapFromView(view), 580);//将view轉bitmap
    }
}
