package com.gingersoft.gsa.delivery_pick_mode.ui.adapter

import android.content.Context
import android.graphics.drawable.GradientDrawable
import android.text.TextUtils
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import android.widget.TextView
import androidx.core.content.ContextCompat
import androidx.databinding.DataBindingUtil
import androidx.recyclerview.widget.RecyclerView
import com.gingersoft.gsa.cloud.pay.contract.PayMethodContract
import com.gingersoft.gsa.delivery_pick_mode.R
import com.gingersoft.gsa.delivery_pick_mode.data.model.bean.HistoryOrderBean.Data.OrderItem
import com.gingersoft.gsa.delivery_pick_mode.databinding.LayoutHistoryOrderItemBinding
import com.scwang.smartrefresh.layout.util.SmartUtil

class HistoryOrderAdapter(var stauts: String?, private val context: Context, var data: List<OrderItem>?) : RecyclerView.Adapter<HistoryOrderAdapter.ViewHolder>() {
    //item點擊事件
    private var listenter: ((item: OrderItem) -> Unit)? = null

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): ViewHolder {
        return ViewHolder(LayoutInflater.from(parent.context).inflate(R.layout.layout_history_order_item, parent, false))
    }

    override fun getItemCount(): Int {
        return if (data == null) {
            0
        } else {
            data!!.size
        }
    }

    override fun onBindViewHolder(holder: ViewHolder, position: Int) {
        val data = data?.get(position)
        holder.binding.data = data
        //堂食外賣背景
        val orderingMethodBg = GradientDrawable()
        orderingMethodBg.shape = GradientDrawable.OVAL
        holder.binding.orderingMethod =
                when {
                    data!!.orderType == 2 -> {
                        orderingMethodBg.setColor(getColor(R.color.order_state2_color))
                        "外"
                    }
                    data.orderType == 7 -> {
                        orderingMethodBg.setColor(getColor(R.color.order_state3_color))
                        "自"
                    }
                    else -> {
                        orderingMethodBg.setColor(getColor(R.color.order_state1_color))
                        "堂"
                    }
                }
        holder.binding.orderingMethodBg = orderingMethodBg

        //支付方式背景 data.orderPayType==1?@color/table_send:@color/table_use
        //data.orderPayType==1?@string/cash_on_delivery:@string/online_payments
        val payMethodBg = GradientDrawable()
        payMethodBg.cornerRadius = SmartUtil.dp2px(10f).toFloat()
        holder.binding.payMethod =
                when (data.orderPayType) {
                    1 -> {
                        payMethodBg.setColor(getColor(R.color.cash_on_delivery_bg))
                        "貨到付款"
                    }
                    else -> {
                        payMethodBg.setColor(getColor(R.color.online_payments_bg))
                        "在線支付"
                    }
                }
        holder.binding.payMethodBg = payMethodBg

        holder.itemView.setOnClickListener {
            listenter?.invoke(data)
        }

        if (stauts != null) {
            if (stauts.equals("4")) {
                //已完成訂單
                holder.iv_end.setImageResource(R.drawable.ic_has_end)
                setReasonViewVisvible(holder);
            } else if (stauts.equals("6")) {
                //已取消訂單
                holder.iv_end.setImageResource(R.drawable.img_cancelled)
                setOrderReason(holder, data.status, data.orderPayType, data.payType, data.reasonDesc);
            }
        } else {
            holder.iv_end.setImageResource(R.drawable.ic_has_end)
        }
    }

    private fun setReasonViewVisvible(holder: ViewHolder) {
        holder.tv_cancel_reason_text.visibility = View.GONE
        holder.tv_cancel_reason.visibility = View.GONE
        holder.tv_refund_reason_text.visibility = View.GONE
        holder.tv_refund_reason.visibility = View.GONE
        holder.tv_address_text.visibility = View.GONE
        holder.tv_address.visibility = View.GONE
    }

    private fun setOrderReason(holder: ViewHolder, refundStatus: Int, orderPayType: Int, payType: Int, reasonDesc: String) {
        val refundReason = getRefundReasonByStatus(refundStatus, orderPayType, payType);
        if (!TextUtils.isEmpty(refundReason)) {
            if (refundStatus == 5) {
                holder.tv_refund_reason.setTextColor(getColor(R.color.green_400))
            } else {
                holder.tv_refund_reason.setTextColor(getColor(R.color.red))
            }
            holder.tv_refund_reason.text = refundReason
            holder.tv_refund_reason_text.text = "退款進度："
            holder.tv_refund_reason_text.visibility = View.VISIBLE
            holder.tv_refund_reason.visibility = View.VISIBLE

            holder.tv_address_text.visibility = View.GONE
            holder.tv_address.visibility = View.GONE
        } else {
            holder.tv_refund_reason_text.visibility = View.GONE
            holder.tv_refund_reason.visibility = View.GONE

            holder.tv_address_text.visibility = View.VISIBLE
            holder.tv_address.visibility = View.VISIBLE
        }
        holder.tv_cancel_reason.setText(reasonDesc)
        holder.tv_cancel_reason_text.setText("取消原因：")
        holder.tv_cancel_reason_text.visibility = View.VISIBLE
        holder.tv_cancel_reason.visibility = View.VISIBLE
    }

    /**
     * 獲取退款說明
     */
    private fun getRefundReasonByStatus(refundStatus: Int, orderPayType: Int, payType: Int): String {
        when (refundStatus) {
            5 -> {
                return "退款完成"
            }
            else -> {
                return when (orderPayType) {
                    1 -> {
                        "無"
                    }
                    else -> {
                        when (payType) {
                            PayMethodContract.PAY_METHOD_ID_1021 -> { //Google pay需要5-7天
                                "退款中(預計5-7個工作日退回原賬戶)"
                            }
                            else -> {
                                "退款中(預計1-3個工作日退回原賬戶)"
                            }
                        }
                    }
                }
            }
        }
        return ""
    }

    private fun getColor(color: Int): Int {
        return ContextCompat.getColor(context, color)
    }

    class ViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {
        var binding: LayoutHistoryOrderItemBinding = DataBindingUtil.bind(itemView)!!
        var iv_end = itemView.findViewById<ImageView>(R.id.iv_end)
        var tv_address_text = itemView.findViewById<TextView>(R.id.tv_address_text)
        var tv_address = itemView.findViewById<TextView>(R.id.tv_address)
        var tv_cancel_reason_text = itemView.findViewById<TextView>(R.id.tv_cancel_reason_text)
        var tv_cancel_reason = itemView.findViewById<TextView>(R.id.tv_cancel_reason)
        var tv_refund_reason_text = itemView.findViewById<TextView>(R.id.tv_refund_reason_text)
        var tv_refund_reason = itemView.findViewById<TextView>(R.id.tv_refund_reason)
    }

    fun setOnItemClickListenter(listenter: (item: OrderItem) -> Unit) {
        this.listenter = listenter
    }
}