package com.gingersoft.gsa.cloud.main.mvp.ui.adapter;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.common.utils.time.TimeUtils;
import com.gingersoft.gsa.cloud.main.R;
import com.gingersoft.gsa.cloud.main.mvp.model.bean.SettlementHistoryListBean;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;

/**
 * @author 宇航. 1239658231@qq.com
 * User: 宇航. 1239658231@qq.com
 * Date: 2021/5/26
 * Time: 18:23
 * Use:
 */
public class LiquidationHistoryAdapter extends BaseQuickAdapter<SettlementHistoryListBean, BaseViewHolder> {
    public LiquidationHistoryAdapter(@Nullable List<SettlementHistoryListBean> data) {
        super(R.layout.item_liquidation_layout, data);
    }

    @Override
    protected void convert(@NotNull BaseViewHolder viewHolder, SettlementHistoryListBean liquidationBean) {
        viewHolder.setText(R.id.tv_liquidation_time, TimeUtils.getTime(liquidationBean.getOperationTime(), TimeUtils.DEFAULT_DATE_FORMAT));
        viewHolder.setText(R.id.tv_liquidation_no, String.format(getContext().getString(R.string.str_clean_up_no), liquidationBean.getId()+""));
    }
}
