package com.gingersoft.gsa.cloud.table.mvp.model.service;

import com.gingersoft.gsa.cloud.common.Api;
import com.gingersoft.gsa.cloud.common.bean.BaseResult;
import com.gingersoft.gsa.cloud.table.mvp.model.bean.response.BaseOrderResponse;
import io.reactivex.Single;
import io.reactivex.Single;
import me.jessyan.retrofiturlmanager.RetrofitUrlManager;
import okhttp3.RequestBody;
import retrofit2.http.Body;
import retrofit2.http.Field;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.GET;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Query;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-01-06
 * 修订历史：2020-01-06
 * 描述：
 */
public interface MealService {

    @Headers({"Domain-Name: soldoutctrl"})
    @POST("foodChecklist/list" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Single<BaseResult> getCurrentSoldoutFood(@Body RequestBody requestBody);

    @Headers({"Domain-Name: soldoutctrl"})
    @POST("foodChecklist/insert" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Single<BaseResult> insertSoldoutCtrl(@Body RequestBody requestBody);

    @Headers({"Domain-Name: soldoutctrl"})
    @POST("foodChecklist/updatePrg" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Single<BaseResult> restoreSoldoutCtrl(@Body RequestBody requestBody);

    @Headers({"Domain-Name: soldoutctrl"})
    @POST("foodChecklist/batchUpdatePrg" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Single<BaseResult> batchRestoreSoldoutCtrl(@Body RequestBody requestBody);

    @POST("food/updateInvisible" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Single<BaseResult> updateInvisible(@Body RequestBody requestBody);

//    @Headers({"Domain-Name: yc_location"})
    @POST("order/send" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Single<BaseResult> createOrder(@Body RequestBody requestBody);

//    @Headers({"Domain-Name: yc_location"})
    @POST("orderDetails/add" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Single<BaseResult> addOrderFood(@Body RequestBody requestBody);

    @FormUrlEncoded
    @POST("order/get" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Single<BaseOrderResponse> loadOrder(@Field("orderId") long orderId);

//    @FormUrlEncoded
    @POST("orderDetails/delete" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Single<BaseResult> deleteFood(@Body RequestBody requestBody);

    @FormUrlEncoded
    @POST("order/calculation/price" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Single<BaseOrderResponse> calculationPrice(@Field("orderId") long orderId);

    @POST("restaurantTable/print" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Single<BaseOrderResponse> printOrder(@Body RequestBody requestBody);

    @GET("restaurantFoodReason/config/list" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Single<BaseResult> getRestaurantFoodReason(@Query("brandId") int brandId , @Query("restaurantId") int restaurantId, @Query("type") int type);

    @POST("restaurantTable/transfer" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Single<BaseOrderResponse> transferFood(@Body RequestBody requestBody);

    @GET(Api.food_list + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Single<BaseResult> downFoodList(@Query("restaurantId") int restaurantId);

    @GET(Api.food_modifiere_relation + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Single<BaseResult> downFoodModifier(@Query("restaurantId") int restaurantId);

}
