/*
 * Decompiled with CFR 0.152.
 */
package it.sauronsoftware.base64;

import it.sauronsoftware.base64.Shared;
import java.io.IOException;
import java.io.InputStream;

public class Base64InputStream
extends InputStream {
    private InputStream inputStream;
    private int[] buffer;
    private int bufferCounter = 0;
    private boolean eof = false;

    public Base64InputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public int available() throws IOException {
        return this.buffer != null ? this.buffer.length : 0;
    }

    public int read() throws IOException {
        if (this.buffer == null || this.bufferCounter == this.buffer.length) {
            if (this.eof) {
                return -1;
            }
            this.acquire();
            if (this.buffer.length == 0) {
                this.buffer = null;
                return -1;
            }
            this.bufferCounter = 0;
        }
        return this.buffer[this.bufferCounter++];
    }

    private void acquire() throws IOException {
        char c;
        int n;
        char[] cArray = new char[4];
        int n2 = 0;
        do {
            if ((n = this.inputStream.read()) == -1) {
                if (n2 != 0) {
                    throw new IOException("Bad base64 stream");
                }
                this.buffer = new int[0];
                this.eof = true;
                return;
            }
            c = (char)n;
            if (Shared.chars.indexOf(c) == -1 && c != Shared.pad) {
                throw new IOException("Bad base64 stream");
            }
            cArray[n2++] = c;
        } while (n2 < 4);
        n = 0;
        for (n2 = 0; n2 < 4; ++n2) {
            if (cArray[n2] != Shared.pad) {
                if (n == 0) continue;
                throw new IOException("Bad base64 stream");
            }
            if (n != 0) continue;
            n = 1;
        }
        if (cArray[3] == Shared.pad) {
            if (this.inputStream.read() != -1) {
                throw new IOException("Bad base64 stream");
            }
            this.eof = true;
            c = cArray[2] == Shared.pad ? (char)'\u0001' : '\u0002';
        } else {
            c = '\u0003';
        }
        int n3 = 0;
        for (n2 = 0; n2 < 4; ++n2) {
            if (cArray[n2] == Shared.pad) continue;
            n3 |= Shared.chars.indexOf(cArray[n2]) << 6 * (3 - n2);
        }
        this.buffer = new int[c];
        for (n2 = 0; n2 < c; ++n2) {
            this.buffer[n2] = n3 >>> 8 * (2 - n2) & 0xFF;
        }
    }

    public void close() throws IOException {
        this.inputStream.close();
    }
}

