package com.gingersoft.supply_chain.mvp.ui.adapter;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.common.utils.time.TimeUtils;
import com.gingersoft.supply_chain.R;
import com.gingersoft.supply_chain.mvp.bean.OrderBean;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;

/**
 * @author 宇航.
 * User: admin
 * Date: 2020/12/2
 * Time: 17:36
 * Use: 採購訂單列表
 */
public class StorageAdapter extends BaseQuickAdapter<OrderBean, BaseViewHolder> {

    public StorageAdapter(@Nullable List<OrderBean> data) {
        super(R.layout.item_storage, data);
        addChildClickViewIds(R.id.btn_storage_buy_again);
    }

    @Override
    protected void convert(@NotNull BaseViewHolder viewHolder, OrderBean purchaseOrderBean) {
        viewHolder.setText(R.id.tv_storage_supplier_name, "供應商名稱");
        viewHolder.setText(R.id.tv_storage_no, "入庫單號");
        viewHolder.setText(R.id.tv_storage_order_no, "" + purchaseOrderBean.getOrderNo());
        viewHolder.setText(R.id.tv_storage_create_time, TimeUtils.getTime(purchaseOrderBean.getCreateTime(), TimeUtils.DEFAULT_DATE_FORMAT_YMDHM));
        viewHolder.setText(R.id.tv_storage_goods_num, purchaseOrderBean.getPurchaseFoodCount() + "");
//        viewHolder.setText(R.id.tv_storage_order_goods, purchaseOrderBean.getFoods());
        viewHolder.setText(R.id.tv_storage_order_total_price, purchaseOrderBean.getTotalAmount() + "");
//        viewHolder.setText(R.id.tv_purchase_order_time_out, purchaseOrderBean.getTotal() + "");
        viewHolder.setText(R.id.btn_storage_order_state, "入庫單狀態");


    }
}
