package com.gingersoft.gsa.cloud.common.config.expandconfig;

import lombok.Getter;
import lombok.Setter;

/**
 * @author : bin
 * @create date: 2020-10-20
 * @update date: 2020-10-20
 * @description:功能擴展配置類（如印單打印次數，是否合併食品）
 */
@Getter
@Setter
public class FunctionExtendedConfiguration {

    private ExpandInfoSetting Rounding = ExpandInfoSetting.builder()
            .valueInt(0)
            .remark("賬單小數相關")
            .build();

    private ExpandInfoSetting RoundingDecimal = ExpandInfoSetting.builder()
            .valueInt(1)
            .remark("賬單小數相關")
            .build();

    private ExpandInfoSetting ItemDecimals = ExpandInfoSetting.builder()
            .valueInt(2)
            .remark("小數位金額")
            .build();

    private ExpandInfoSetting DeliveryPrintCount = ExpandInfoSetting.builder()
            .valueInt(1)
            .remark("外送印單打印次數")
            .build();

    private ExpandInfoSetting DeliveryClosingPC = ExpandInfoSetting.builder()
            .valueInt(1)
            .remark("外送結賬打印次數")
            .build();

    private ExpandInfoSetting OrderReceivingTimeout = ExpandInfoSetting.builder()
            .valueInt(60 * 60 * 1000)
            .remark("外送接單超時時間")
            .build();

    private ExpandInfoSetting FrozenChainAutoOrder = ExpandInfoSetting.builder()
            .valueBoolean(true)
            .remark("是否自動接單 為0true")
            .build();


    private ExpandInfoSetting TableModePrintCount = ExpandInfoSetting.builder()
            .valueInt(1)
            .remark("餐檯印單打印次數")
            .build();

    private ExpandInfoSetting TableModeClosingPC = ExpandInfoSetting.builder()
            .valueInt(1)
            .remark("餐檯模式結賬單打印次數")
            .build();

    private ExpandInfoSetting PrintMemberInfo = ExpandInfoSetting.builder()
            .valueBoolean(false)
            .remark("是否打印會員信息")
            .build();

    private ExpandInfoSetting PrintPage = ExpandInfoSetting.builder()
            .valueBoolean(false)
            .remark("是否打印頁數")
            .build();

    private ExpandInfoSetting PrintMergerFood = ExpandInfoSetting.builder()
            .valueBoolean(false)
            .remark("是否合併食品")
            .build();

    private ExpandInfoSetting PrintStatisticsAmount = ExpandInfoSetting.builder()
            .valueBoolean(false)
            .remark("是否顯示統計打印數")
            .build();

    private ExpandInfoSetting PrintFirstOrder = ExpandInfoSetting.builder()
            .valueBoolean(false)
            .remark("是否打印\"頭單\"文字")
            .build();

    private ExpandInfoSetting MergeSendFood = ExpandInfoSetting.builder()
            .valueBoolean(false)
            .remark("送單是否自動合併食品")
            .build();

    private ExpandInfoSetting AutoPrinterPaper = ExpandInfoSetting.builder()
            .valueBoolean(false)
            .remark("送單自動打印上菜紙")
            .build();

    private ExpandInfoSetting ToPrintQRCode = ExpandInfoSetting.builder()
            .valueBoolean(false)
            .remark("結賬是否打印積分二維碼")
            .build();

    private ExpandInfoSetting AutoQuitTime = ExpandInfoSetting.builder()
            .valueInt(600)
            .remark("餐檯模式下單頁多少秒不操作返回餐檯頁面")
            .build();

    private ExpandInfoSetting SelectPaymentAutoShowKeyboard = ExpandInfoSetting.builder()
            .valueBoolean(false)
            .remark("點選支付方式是否彈出輸入框")
            .build();

    private ExpandInfoSetting OpenTableAutoShowKeyboard = ExpandInfoSetting.builder()
            .valueBoolean(true)
            .remark("餐檯模式開檯自動彈出輸入人數彈窗")
            .build();

    private ExpandInfoSetting PluNumberChar = ExpandInfoSetting.builder()
            .valueChar("ABCDEFGHIJKLMNOPQRSTUVWXYZ")
            .remark("PLU左側滑動信息配置")
            .build();

    /**
     * skyorder相關
     */
    private ExpandInfoSetting QRCodeTimeSlice = ExpandInfoSetting.builder()
            .valueChar("00,15,30,45")
            .remark("QRCode交台时间片（分）使用逗号分隔")
            .build();

    private ExpandInfoSetting SkyQRCodeTableFlagText = ExpandInfoSetting.builder()
            .valueChar("S")
            .remark("skyorder QRCode餐檯標記")
            .build();

    private ExpandInfoSetting SkyQRCodePrintTopInfo = ExpandInfoSetting.builder()
            .valueChar("頂部打印可配置文字")
            .remark("qrcode頂部文字")
            .build();

    private ExpandInfoSetting SkyQRCodePrintBottomInfo = ExpandInfoSetting.builder()
            .valueChar("底部打印可配置文字")
            .remark("qrcode底部文字")
            .build();


    public <T> T getPluNumberCharVaule() {
        return PluNumberChar.getValue();
    }

    public <T> T getRoundingVaule() {
        return Rounding.getValue();
    }

    public <T> T getRoundingDecimalVaule() {
        return RoundingDecimal.getValue();
    }

    public <T> T getItemDecimalsValue() {
        return ItemDecimals.getValue();
    }

    public <T> T getDeliveryPrintCountVaule() {
        return DeliveryPrintCount.getValue();
    }

    public <T> T getDeliveryClosingPCVaule() {
        return DeliveryClosingPC.getValue();
    }

    public <T> T getTableModePrintCountVaule() {
        return TableModePrintCount.getValue();
    }

    public <T> T getTableModeClosingPCVaule() {
        return TableModeClosingPC.getValue();
    }

    public <T> T getOrderReceivingTimeoutVaule() {
        return OrderReceivingTimeout.getValue();
    }

    public <T> T getPrintMemberInfoVaule() {
        return PrintMemberInfo.getValue();
    }

    public <T> T getPrintPageVaule() {
        return PrintPage.getValue();
    }

    public <T> T getPrintMergerFoodVaule() {
        return PrintMergerFood.getValue();
    }

    public <T> T getPrintStatisticsAmountVaule() {
        return PrintStatisticsAmount.getValue();
    }

    public <T> T getPrintFirstOrderVaule() {
        return PrintFirstOrder.getValue();
    }

    public <T> T getFrozenChainAutoOrderVaule() {
        return FrozenChainAutoOrder.getValue();
    }

    public <T> T getMergeSendFoodVaule() {
        return MergeSendFood.getValue();
    }

    public <T> T getAutoPrinterPaperVaule() {
        return AutoPrinterPaper.getValue();
    }

    public <T> T getToPrintQRCodeVaule() {
        return ToPrintQRCode.getValue();
    }

    public <T> T getAutoQuitTimeVaule() {
        return AutoQuitTime.getValue();
    }

    public <T> T getQRCodeTimeSliceVaule() {
        return QRCodeTimeSlice.getValue();
    }

    public <T> T getSkyQRCodeTableFlagTextVaule() {
        return SkyQRCodeTableFlagText.getValue();
    }

    public <T> T getSkyQRCodePrintTopInfoVaule() {
        return SkyQRCodePrintTopInfo.getValue();
    }

    public <T> T getSkyQRCodePrintBottomInfoVaule() {
        return SkyQRCodePrintBottomInfo.getValue();
    }

    public <T> T getSelectPaymentAutoShowKeyboardVaule() {
        return SelectPaymentAutoShowKeyboard.getValue();
    }

    public <T> T getOpenTableAutoShowKeyboardVaule() {
        return OpenTableAutoShowKeyboard.getValue();
    }

}
