package com.joe.print.mvp.print;

import android.content.Context;
import android.graphics.Bitmap;
import android.widget.LinearLayout;

import com.gingersoft.gsa.cloud.base.common.bean.BillingBean;
import com.gingersoft.gsa.cloud.base.common.bean.MemberInfo;
import com.gingersoft.gsa.cloud.base.order.bean.BillOrderMoney;
import com.gingersoft.gsa.cloud.base.order.bean.OrderDetail;
import com.gingersoft.gsa.cloud.base.order.bean.mealManger.MyOrderManage;
import com.gingersoft.gsa.cloud.base.order.bean.mealManger.OpenTableManage;
import com.gingersoft.gsa.cloud.base.table.bean.TableBean;
import com.gingersoft.gsa.cloud.base.utils.RestaurantExpandInfoUtils;
import com.gingersoft.gsa.cloud.base.utils.other.TextUtil;
import com.gingersoft.gsa.cloud.base.utils.time.TimeUtils;
import com.gingersoft.gsa.cloud.constans.ExpandConstant;
import com.gingersoft.gsa.cloud.database.bean.PrinterDeviceBean;
import com.gingersoft.gsa.cloud.print.bean.OrderDetails;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 結賬單  已改新版
 */
public class PrintBill extends PrinterRoot {

    @Override
    public Map<String, List<Bitmap>> getPrintBitmap(Context mContext, PrinterDeviceBean deviceBean) {
        Map<String, List<Bitmap>> bitmapMaps = new HashMap<>();
        List<Bitmap> bitmaps = new ArrayList<>();
        bitmaps.add(getBitmap(mContext, deviceBean));
        bitmapMaps.put("", bitmaps);
        return bitmapMaps;
    }

    @Override
    public String getPrintData(Context mContext, PrinterDeviceBean deviceBean) {
        return null;
    }

    @Override
    public int getPrintCount(Context context) {
        return RestaurantExpandInfoUtils.getValue(ExpandConstant.TableModeClosingPC, 1);
    }

    private Bitmap getBitmap(Context mContext, PrinterDeviceBean deviceBean) {
        List<OrderDetail> foodList = MyOrderManage.getInstance().getOrderFoodList();
        TableBean.DataBean tableBean = OpenTableManage.getDefault().getTableBean();

        LinearLayout layout = new LinearLayout(mContext);
        layout.setOrientation(LinearLayout.VERTICAL);

        //訂單頭
        layout.addView(getHeader(mContext));
        layout.addView(getLine(mContext));

        //訂單信息
        String tableName = "餐檯：" + tableBean.getTableName();
        String peopleNum = "人數：" + OpenTableManage.getDefault().getPeopleNumber();
        String orderNum = "單號：";
        if (TextUtil.isNotEmptyOrNullOrUndefined(MyOrderManage.getInstance().getOrderNo())) {
            orderNum = "單號：" + MyOrderManage.getInstance().getOrderNo();
        }
        String createTime = "日期：" + TimeUtils.parseTimeRepeat(tableBean.getCreateTime(), TimeUtils.DEFAULT_DATE_FORMAT);
        layout.addView(getDiningTableOrderInfo(mContext, tableName, peopleNum, orderNum, createTime));
        layout.addView(getLine(mContext));

        //食品信息
        layout.addView(getDiningFoodList(mContext, foodList, deviceBean, 1, true));
        layout.addView(getHalfLine(mContext));

        //訂單金額信息
        List<BillingBean> billingBeans = new ArrayList<>();
        //添加合計項
        billingBeans.add(new BillingBean("合計", MyOrderManage.getInstance().getWholeAmount()));
        //添加其他金額項
        if (MyOrderManage.getInstance().getOrderMoneyList().size() > 0) {
            for (BillOrderMoney item : MyOrderManage.getInstance().getOrderMoneyList()) {
                billingBeans.add(new BillingBean(item.getTitle(), item.getMoney()));
            }
        }
        layout.addView(getDiningBillInfo(mContext, billingBeans));


        layout.addView(getHalfLine(mContext));

//        BigDecimal totalAmount = new BigDecimal(0);
//        for (OrderDetail OrderDetail : MyOrderManage.getInstance().getOrderFoodList()) {
//            totalAmount = MoneyUtil.sum(totalAmount, OrderDetail.getPrice());
//        }
        layout.addView(getAmountText(mContext, "總金額：" + MyOrderManage.getInstance().getTotalAmount()));
        layout.addView(getLine(mContext));
        layout.addView(getDiningBillPayMethod(mContext, MyOrderManage.getInstance().getBillMoney()));
        layout.addView(getLine(mContext));

        layout.addView(getTableMealMemberIntegerView(mContext, getOrderMemberInfo(), MyOrderManage.getInstance().getIntegralQrcode()));

        return zoomBitmap(deviceBean, viewToBitmap(mContext, layout));
    }


    private OrderDetails.DataBean getOrderMemberInfo() {
        OrderDetails.DataBean dataBean = new OrderDetails.DataBean();
        MemberInfo memberInfo = MyOrderManage.getInstance().getMemberInfo();
        if (memberInfo != null) {
            dataBean.setMEMBER_NAME(memberInfo.getMemberName());
            dataBean.setPHONE(memberInfo.getPhone());
            dataBean.setNowPoints(MyOrderManage.getInstance().getNowPoints());
            dataBean.setAddPoints(MyOrderManage.getInstance().getAddPoints());
            dataBean.setOldPoints(MyOrderManage.getInstance().getOldPoints());
        }
        return dataBean;
    }

}
