package com.gingersoft.gsa.cloud.bean.mvp.model.discount;

import com.gingersoft.gsa.cloud.base.common.bean.MemberInfo;
import com.gingersoft.gsa.cloud.base.utils.MoneyUtil;

import lombok.Getter;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-09-19
 * 修订历史：2020-09-19
 * 描述: 會員折扣{@link MemberInfo#memberDiscount}
 */
@Getter
public class MemberDiscount extends MultyDiscount {

    private MemberInfo memberDiscount;
    /**
     * 本次折扣金额
     */
    private Double discountMoney;

    public MemberDiscount(MultyDiscount nextMultyDiscount, MemberInfo memberDiscount) {
        super(nextMultyDiscount);
        this.memberDiscount = memberDiscount;
    }

    @Override
    public double calculate(double money) {

        if (memberDiscount != null) {
            discountMoney = calculationMemberDiscount(memberDiscount.getMemberDiscount(), money);
            money = MoneyUtil.sum(money,discountMoney);
        }

        return super.calculate(money);
    }

    public static double calculationMemberDiscount(int discountRate, double sourceMoney) {
        double discountMoney = MoneyUtil.divide(MoneyUtil.multiply(sourceMoney, discountRate), 100).doubleValue();
        if (sourceMoney < discountMoney) {
            //折扣金額不能超出總額
            discountMoney = sourceMoney;
        }
        return -MoneyUtil.get_ItemDecimals_money(Math.abs(discountMoney));
    }
}
