package com.gingersoft.gsa.cloud.bean.mvp.ui.adapter;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.gingersoft.gsa.cloud.base.application.GsaCloudApplication;
import com.gingersoft.gsa.cloud.bean.R;
import com.gingersoft.gsa.cloud.bean.R2;
import com.gingersoft.gsa.cloud.bean.mvp.model.bean.SoldoutCtrFood;
import com.jess.arms.base.BaseHolder;
import com.jess.arms.base.DefaultAdapter;

import java.util.List;

import butterknife.BindView;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2018/6/27
 * 修订历史：2018/6/27
 * 描述：
 */

public class CurrentSlodoutFoodAdapter extends DefaultAdapter<SoldoutCtrFood> {

    private Context mContext;
    //字体大小
    private int soldoutCtrlFoodFontSize;

    private int select_position = 0;


    public CurrentSlodoutFoodAdapter(Context context, List<SoldoutCtrFood> infos) {
        super(infos);
        this.mContext = context;
        this.soldoutCtrlFoodFontSize = GsaCloudApplication.uiStyleConfiguration.getSoldoutCtrlFoodFontSize();
    }

    public void setSelectPosition(int select_position) {
        this.select_position = select_position;
        set_SelectPosition();
    }

    private void set_SelectPosition() {
        //查找自己的
        if (select_position == -1 || mInfos == null || mInfos.size() < 1) {
            return;
        }
        List<SoldoutCtrFood> datasBeans = mInfos;
        for (int i = 0; i < datasBeans.size(); i++) {
            if (i == select_position) {
                datasBeans.get(i).setSelected(1);
            } else {
                datasBeans.get(i).setSelected(0);
            }
        }

//        for (int i = 0; i < datasBeans.size(); i++) {
//            if (i == select_position) {
////                datasBeans.get(i).setSelected(1);
//                if (datasBeans.get(i).getSelected() == 1) {
//                    datasBeans.get(i).setSelected(0);
//                } else {
//                    datasBeans.get(i).setSelected(1);
//                }
//            } else {
//                if (datasBeans.get(i).getSelected() == 0) {
//                    datasBeans.get(i).setSelected(0);
//                }
//            }
//        }
    }

    @Override
    public int getItemCount() {
        return mInfos.size();
    }

    @Override
    public BaseHolder<SoldoutCtrFood> getHolder(View v, int viewType) {
        return new CurrentSlodoutItemHolder(v);
    }

    @Override
    public int getLayoutId(int viewType) {
        return R.layout.meal_item_current_soldout_food;
    }

    class CurrentSlodoutItemHolder extends BaseHolder<SoldoutCtrFood> {

        @BindView(R2.id.rl_select)
        RelativeLayout rl_select;
        @BindView(R2.id.tv_number)
        TextView tv_number;
        @BindView(R2.id.tv_name)
        TextView tv_name;
        @BindView(R2.id.tv_value)
        TextView tv_value;

        public CurrentSlodoutItemHolder(View itemView) {
            super(itemView);
        }

        @Override
        public void setData(SoldoutCtrFood datasBean, int position) {

            String name = datasBean.getName();
            if (!TextUtils.isEmpty(name)) {
                tv_name.setText(name);
            } else {
                tv_name.setText("");
            }

//            tv_number.setText(String.valueOf(position + 1));
            tv_number.setText("");

            tv_value.setText(datasBean.getQtyName());
            //设置字体
            tv_value.setTextSize(soldoutCtrlFoodFontSize);
            tv_name.setTextSize(soldoutCtrlFoodFontSize);
            tv_number.setTextSize(soldoutCtrlFoodFontSize);

            int selected = datasBean.getSelected();
            switch (selected) {
                case 1://选中，第一层选中.
                    rl_select.setBackgroundColor(mContext.getResources().getColor(R.color.theme_background_color));
                    tv_number.setTextColor(mContext.getResources().getColor(R.color.theme_black));
                    tv_name.setTextColor(mContext.getResources().getColor(R.color.theme_black));
                    tv_value.setTextColor(mContext.getResources().getColor(R.color.theme_black));
                    break;
                default://未选 中。黑底白字
                    rl_select.setBackgroundColor(mContext.getResources().getColor(R.color.theme_white_color));
                    tv_number.setTextColor(mContext.getResources().getColor(R.color.theme_black));
                    tv_name.setTextColor(mContext.getResources().getColor(R.color.theme_black));
                    tv_value.setTextColor(mContext.getResources().getColor(R.color.theme_black));
                    break;
            }

            rl_select.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    if (mOnItemClickListener != null) {
                        mOnItemClickListener.onItemClick(datasBean, position);
                    }
                }
            });
        }
    }


    public int getSelectPosition() {
        return this.select_position;
    }

    private OnItemClickListener mOnItemClickListener;

    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        mOnItemClickListener = onItemClickListener;
    }

    public interface OnItemClickListener {

        void onItemClick(SoldoutCtrFood datasBean, int position);

    }

}
