package com.gingersoft.gsa.cloud.main.mvp.ui.view;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Typeface;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.gingersoft.gsa.cloud.main.R;
import com.gingersoft.gsa.cloud.ui.bean.view.SectionHeader;
import com.qmuiteam.qmui.util.QMUIDisplayHelper;

/**
 * Created by Wyh on 2020/1/10.
 */
public class HomeFunctionHead extends LinearLayout {

    private TextView mTitleTv;
//    private ImageView mArrowView;

//    private int headerHeight = QMUIDisplayHelper.dp2px(getContext(), 56);

    public HomeFunctionHead(Context context) {
        this(context, null);
    }

    public HomeFunctionHead(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        setOrientation(LinearLayout.HORIZONTAL);
        setGravity(Gravity.CENTER_VERTICAL);
        setBackgroundColor(Color.WHITE);
        int paddingHor = QMUIDisplayHelper.dp2px(context, 5);
        int paddingVer = QMUIDisplayHelper.dp2px(context, 5);
        mTitleTv = new TextView(getContext());
        mTitleTv.setTextSize(14);
        mTitleTv.setTypeface(Typeface.DEFAULT_BOLD);
        mTitleTv.setTextColor(getColor(context, R.color.theme_color));
        mTitleTv.setPadding(paddingHor, paddingVer, paddingHor, paddingVer);
        addView(mTitleTv, new LinearLayout.LayoutParams(0, ViewGroup.LayoutParams.WRAP_CONTENT, 1f));
        setBackgroundColor(getColor(context, R.color.main_home_function_head_bg));
//        mArrowView = new AppCompatImageView(context);
//        mArrowView.setImageDrawable(QMUIResHelper.getAttrDrawable(getContext(), R.attr.qmui_common_list_item_chevron));
//        mArrowView.setScaleType(ImageView.ScaleType.CENTER);
//        addView(mArrowView, new LinearLayout.LayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT));
    }

    private int getColor(Context context, int colorId) {
        return context.getResources().getColor(colorId);
    }

//    public ImageView getArrowView() {
//        return mArrowView;
//    }

    public void render(SectionHeader header, boolean isFold) {
        mTitleTv.setText(header.getText());
//        mArrowView.setRotation(isFold ? 0f : 90f);
    }
//
//    @Override
//    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
//        super.onMeasure(widthMeasureSpec,  MeasureSpec.makeMeasureSpec(headerHeight, MeasureSpec.EXACTLY));
//    }
}