package com.gingersoft.supply_chain.mvp.content;

import com.gingersoft.supply_chain.mvp.bean.OrderCategoryBean;
import com.gingersoft.supply_chain.mvp.bean.PurchaseFoodBean;
import com.gingersoft.supply_chain.mvp.bean.SupplierInfoBean;
import com.xuexiang.rxutil2.rxjava.RxJavaUtils;
import com.xuexiang.rxutil2.rxjava.task.RxIOTask;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/**
 * @author 宇航.
 * User: admin
 * Date: 2020/12/4
 * Time: 11:21
 * Use: 供應鏈購物車,需要緩存用戶選中的食品
 */
public class SupplyShoppingCart {
    /**
     * key為食品id
     * value為食品信息
     */
    private static List<PurchaseFoodBean> cartFoods;
    /**
     * 供應商信息map
     * 有時候PurchaseFoodBean中的供應商信息不可靠，比如：用戶將食品添加到購物車中，然後又去供應商列表修改供應商信息，這時候需要更新供應商信息
     */
    private static Map<Integer, SupplierInfoBean> supplierInfoBeanMap;

    private static SupplyShoppingCart shoppingCart;

    public static SupplyShoppingCart getInstance() {
        if (shoppingCart == null) {
            shoppingCart = new SupplyShoppingCart();
        }
        return shoppingCart;
    }

    public List<PurchaseFoodBean> getCartFoods() {
        if (cartFoods == null) {
            cartFoods = new ArrayList<>();
        }
        return cartFoods;
    }

    public Map<Integer, SupplierInfoBean> getSupplierInfoBeanMap() {
        if (supplierInfoBeanMap == null) {
            supplierInfoBeanMap = new HashMap<>();
        }
        return supplierInfoBeanMap;
    }

    public SupplierInfoBean getSupplierById(int supplierId) {
        return getSupplierInfoBeanMap().get(supplierId);
    }

    public void updateSupplier(SupplierInfoBean supplierInfoBean) {
        getSupplierInfoBeanMap().put(supplierInfoBean.getId(), supplierInfoBean);
    }

    public void addAllFood(Collection<PurchaseFoodBean> purchaseFoodBeans) {
        for (PurchaseFoodBean purchaseFoodBean : purchaseFoodBeans) {
            addFood(purchaseFoodBean);
        }
    }

    /**
     * 添加食品時記錄供應商信息，對供應商進行修改時，需要修改食材的供應商信息
     *
     * @param purchaseFoodBean
     */
    public void addFood(PurchaseFoodBean purchaseFoodBean) {
        addFood(getCartFoods().size(), purchaseFoodBean);
    }

    public void addFood(int index, PurchaseFoodBean purchaseFoodBean) {
        getCartFoods().add(index, purchaseFoodBean);
        if (getSupplierInfoBeanMap().get(purchaseFoodBean.getSupplierId()) == null) {
            getSupplierInfoBeanMap().put(purchaseFoodBean.getSupplierId(), SupplierInfoBean.generateSupplierByFood(purchaseFoodBean));
        }
    }

    public void replaceFood(PurchaseFoodBean purchaseFoodBean) {
        RxJavaUtils.doInIOThread(new RxIOTask<Object>(1) {
            @Override
            public Void doInIOThread(Object o) {
                for (int i = 0; i < getCartFoods().size(); i++) {
                    PurchaseFoodBean cartFood = getCartFoods().get(i);
                    //找到這個食品
                    if (purchaseFoodBean.getId().equals(cartFood.getId())) {
                        int foodNum = cartFood.getFoodQuantity();
                        purchaseFoodBean.setFoodQuantity(foodNum);
                        if (getSupplierInfoBeanMap().get(purchaseFoodBean.getSupplierId()) != null) {
                            //可能用戶修改了食品的供應商信息，但是這裡是沒有供應商的詳細，直接移除食品
                            getCartFoods().add(i, purchaseFoodBean);
                        }
                        cartFoods.remove(cartFood);
                        break;
                    }
                }
                return null;
            }
        });
    }

    public void clear() {
        if (cartFoods == null) {
            return;
        }
        cartFoods.clear();
    }


    public void removeFoodsByFoodId(int foodId) {
        RxJavaUtils.doInIOThread(new RxIOTask<Object>(0) {
            @Override
            public Void doInIOThread(Object o) {
                //刪除供應商成功後，需要從購物車數據中將這個供應商的食材都刪除掉
                List<PurchaseFoodBean> cartFoods = SupplyShoppingCart.getInstance().getCartFoods();
                Iterator<PurchaseFoodBean> iterator = cartFoods.iterator();
                while (iterator.hasNext()) {
                    PurchaseFoodBean next = iterator.next();
                    if (next.getId() != null && next.getId() == foodId) {
                        iterator.remove();
                        break;
                    }
                }
                return null;
            }
        });
    }

    public void removeFoodsBySupplier(int supplierId) {
        RxJavaUtils.doInIOThread(new RxIOTask<Object>(0) {
            @Override
            public Void doInIOThread(Object o) {
                //刪除供應商成功後，需要從購物車數據中將這個供應商的食材都刪除掉
                List<PurchaseFoodBean> cartFoods = SupplyShoppingCart.getInstance().getCartFoods();
                Iterator<PurchaseFoodBean> iterator = cartFoods.iterator();
                while (iterator.hasNext()) {
                    PurchaseFoodBean next = iterator.next();
                    if (next.getSupplierId() != null && next.getSupplierId() == supplierId) {
                        iterator.remove();
                    }
                }
                return null;
            }
        });
    }

    public void removeFoodsByCategoryId(int categoryId) {
        RxJavaUtils.doInIOThread(new RxIOTask<Object>(0) {
            @Override
            public Void doInIOThread(Object o) {
                //刪除供應商成功後，需要從購物車數據中將這個供應商的食材都刪除掉
                List<PurchaseFoodBean> cartFoods = SupplyShoppingCart.getInstance().getCartFoods();
                Iterator<PurchaseFoodBean> iterator = cartFoods.iterator();
                while (iterator.hasNext()) {
                    PurchaseFoodBean next = iterator.next();
                    if (next.getFoodCategoryId() != null && next.getFoodCategoryId() == categoryId) {
                        iterator.remove();
                    }
                }
                return null;
            }
        });
    }

    public void removeFoodsByCategoryTress(OrderCategoryBean.FoodCategoryTrees foodCategoryTrees) {
        RxJavaUtils.doInIOThread(new RxIOTask<Object>(0) {
            @Override
            public Void doInIOThread(Object o) {
                //刪除分類成功後，需要從購物車數據中將這個分類的食材都刪除掉
                List<PurchaseFoodBean> cartFoods = SupplyShoppingCart.getInstance().getCartFoods();
                Iterator<PurchaseFoodBean> iterator = cartFoods.iterator();
                while (iterator.hasNext()) {
                    PurchaseFoodBean next = iterator.next();
                    if (next.getFoodCategoryId() != null && next.getFoodCategoryId() == foodCategoryTrees.getId()) {
                        iterator.remove();
                    }
                }
                //分類中的刪除完了，需要刪除分類下子分類的食材
                List<OrderCategoryBean.FoodCategoryTrees> childCategory = foodCategoryTrees.getFoodCategoryTrees();
                if (childCategory != null) {
                    //遍歷二級分類
                    for (OrderCategoryBean.FoodCategoryTrees categoryTrees : childCategory) {
                        for (PurchaseFoodBean cartFood : cartFoods) {
                            if (cartFood.getFoodCategoryId() == categoryTrees.getId()) {
                                cartFoods.remove(cartFood);
                                break;
                            }
                        }
                        //對三級分類進行遍歷
                        List<OrderCategoryBean.FoodCategoryTrees> thirdCategory = categoryTrees.getFoodCategoryTrees();
                        removeFoodsByCategoryTress(thirdCategory);
                    }
                }
                return null;
            }
        });
    }

    public void removeFoodsByCategoryTress(List<OrderCategoryBean.FoodCategoryTrees> thirdCategory) {
        if (thirdCategory != null) {
            for (OrderCategoryBean.FoodCategoryTrees trees : thirdCategory) {
                for (PurchaseFoodBean cartFood : cartFoods) {
                    if (cartFood.getFoodCategoryId() == trees.getId()) {
                        cartFoods.remove(cartFood);
                    }
                }
            }
        }
    }

}
