package com.gingersoft.gsa.cloud.pay.pos;

import android.content.Context;

import com.etps.aca.lib.activity.CommandActivity;
import com.gingersoft.gsa.cloud.pay.pos.bean.BaseBgRequest;
import com.gingersoft.gsa.cloud.pay.pos.bean.BasePosRequest;
import com.gingersoft.gsa.cloud.pay.pos.hyweb.bean.request.bg.GetTxnIdRequest;
import com.gingersoft.gsa.cloud.pay.pos.hyweb.bean.request.pos.RetrievalRequest;
import com.gingersoft.gsa.cloud.pay.pos.hyweb.bean.request.pos.SaleRequest;
import com.gingersoft.gsa.cloud.pay.pos.hyweb.command.CommandImpl;
import com.gingersoft.gsa.cloud.pay.pos.hyweb.imp.IHywebAction;
import com.gingersoft.gsa.cloud.pay.pos.hyweb.imp.PrintPaymentStubImpl;
import com.gingersoft.gsa.cloud.pay.pos.hyweb.imp.RefundActionImpl;
import com.gingersoft.gsa.cloud.pay.pos.hyweb.imp.RetrievalActionImpl;
import com.gingersoft.gsa.cloud.pay.pos.hyweb.imp.SaleActionImpl;
import com.gingersoft.gsa.cloud.pay.pos.hyweb.imp.SettlementActionImpl;
import com.gingersoft.gsa.cloud.pay.pos.hyweb.imp.TipsActionImpl;
import com.gingersoft.gsa.cloud.pay.pos.hyweb.imp.VoidActionImpl;
import com.jess.arms.mvp.IView;

import lombok.Builder;
import okhttp3.internal.ws.RealWebSocket;

/**
 * @作者: bin
 * @創建時間: 2020-12-26 10:32
 * @更新時間: 2020-12-26 10:32
 * @描述:
 */
@Builder
public final class PosPay {

    final Context context;
    final IView lifecycleView;
    final BasePosRequest posRequest;
    final BaseBgRequest bgRequest;
    final PosAction retrievalAction;
    final OnPosActionListener onPosActionListener;
    final boolean showLoading;

    public static void sendRequest(IHywebAction action) {
        CommandActivity.setCommand(new CommandImpl(action));
//        if (AppDevice.isHywebPos()) {
//        if (action != null) {
//            action.onPosActionBefore();
//        }
//        } else if (AppDevice.isBBPos()) {
//        } else {
//        }
    }

    public void pay() {
        PosPay.sendRequest(new SaleActionImpl(context, lifecycleView, PosAction.SALE, (SaleRequest) posRequest, (GetTxnIdRequest) bgRequest, onPosActionListener, true));
    }

    public void tip() {
//        PosPay.sendRequest(new TipsActionImpl(context, lifecycleView, PosAction.TIP, txnIdRequest, tipRequest, onPosActionListener, true));
    }

    public void refund() {
//        PosPay.sendRequest(new RefundActionImpl(context, lifecycleView, PosAction.REFUND, request, getTxnIdRequest, onPosActionListener, true));
    }

    public void voidO() {
//        PosPay.sendRequest(new VoidActionImpl(context, lifecycleView, PosAction.VOID, request, getTxnIdRequest, onPosActionListener, true));
    }

    public static void retrieval(Context context, IView lifecycleView, Long orderId, PosAction retrievalAction, RetrievalRequest request, OnPosActionListener onPosActionListener) {
        PosPay.sendRequest(new RetrievalActionImpl(context, lifecycleView, PosAction.RETRIEVAL, retrievalAction, orderId, request, onPosActionListener, false));
    }

    public void printStub() {
//        PosPay.sendRequest(new PrintPaymentStubImpl(context, lifecycleView, PosAction.PRINT, txnId, onPosActionListener, true));
    }

    public void settlement() {
        PosPay.sendRequest(new SettlementActionImpl(context, lifecycleView, PosAction.SETTLEMENT, onPosActionListener, true));
    }
}
