package com.gingersoft.gsa.cloud.common.utils.glide;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.widget.ImageView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.Request;
import com.bumptech.glide.request.RequestOptions;
import com.bumptech.glide.request.target.SizeReadyCallback;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.request.transition.Transition;
import com.gingersoft.gsa.cloud.common.utils.log.LogUtil;
import com.jess.arms.di.component.AppComponent;
import com.jess.arms.http.imageloader.ImageLoader;
import com.jess.arms.http.imageloader.glide.GlideArms;
import com.jess.arms.http.imageloader.glide.GlideRequest;
import com.jess.arms.http.imageloader.glide.GlideRequests;
import com.jess.arms.http.imageloader.glide.ImageConfigImpl;
import com.jess.arms.utils.ArmsUtils;

import java.util.concurrent.ExecutionException;

/**
 * Description : 图片加载工具类 使用glide框架封装
 */
public class GlideUtils {

    public static void display(Context context, ImageView imageView, String url) {

        if (imageView == null) {
            throw new IllegalArgumentException("argument error");
        }

        //可以在任何可以拿到 Context 的地方,拿到 AppComponent,从而得到用 Dagger 管理的单例对象
        AppComponent mAppComponent = ArmsUtils.obtainAppComponentFromContext(context);
        ImageLoader mImageLoader = mAppComponent.imageLoader();//用于加载图片的管理类,默认使用 Glide,使用策略模式,可替换框架
        mImageLoader.loadImage(context,
                ImageConfigImpl
                        .builder()
                        .url(url)
                        .imageView(imageView)
                        .build());
    }

    public static void display(Context context, ImageView imageView, String url, int placeholder) {
        if (url == null) {
            return;
        }
        if (imageView == null) {
            throw new IllegalArgumentException("argument error");
        }

        //可以在任何可以拿到 Context 的地方,拿到 AppComponent,从而得到用 Dagger 管理的单例对象
        AppComponent mAppComponent = ArmsUtils.obtainAppComponentFromContext(context);
        ImageLoader mImageLoader = mAppComponent.imageLoader();//用于加载图片的管理类,默认使用 Glide,使用策略模式,可替换框架
        mImageLoader.loadImage(context,
                ImageConfigImpl
                        .builder()
                        .url(url)
                        .placeholder(placeholder)
                        .imageView(imageView)
                        .build());
    }

    public static void display(Context context, ImageView imageView, String url, int placeholder, int error, int fallback) {

        if (imageView == null) {
            throw new IllegalArgumentException("argument error");
        }

        //可以在任何可以拿到 Context 的地方,拿到 AppComponent,从而得到用 Dagger 管理的单例对象
        AppComponent mAppComponent = ArmsUtils.obtainAppComponentFromContext(context);
        ImageLoader mImageLoader = mAppComponent.imageLoader();//用于加载图片的管理类,默认使用 Glide,使用策略模式,可替换框架
        mImageLoader.loadImage(context,
                ImageConfigImpl
                        .builder()
                        .url(url)
                        .placeholder(placeholder)
                        .errorPic(error)
                        .fallback(fallback)
                        .imageView(imageView)
                        .build());
    }

    /**
     * 加载圆形图片
     *
     * @param context
     * @param imageView
     * @param url
     */
    public static void displayRound(Context context, ImageView imageView, String url) {
        if (imageView == null) {
            throw new IllegalArgumentException("argument error");
        }

        //如果context是activity则自动使用Activity的生命周期
        GlideRequests requests = GlideArms.with(context);
        GlideRequest<Drawable> glideRequest = requests.load(url)
                .fitCenter();
//        glideRequest.transform(new GlideRoundTransformUtil(context));
//        glideRequest.diskCacheStrategy(DiskCacheStrategy.ALL);
//        glideRequest.placeholder(R.drawable.icn_profile_pic);
//        glideRequest.error(R.drawable.icn_profile_pic);
//        glideRequest.fallback(R.drawable.icn_profile_pic);
//        glideRequest.into(imageView);
    }

    /**
     * 自适应宽度加载图片。保持图片的长宽比例不变，通过修改imageView的高度来完全显示图片。
     */
    public static void loadIntoUseFitWidth(Context context, final String imageUrl, int errorImageId, final ImageView imageView) {
        GlideArms.with(context)
                .setDefaultRequestOptions(new RequestOptions()
//                                        .frame(3000000)
//                                .centerCrop()
                                .diskCacheStrategy(DiskCacheStrategy.ALL)
                                .error(errorImageId)
                                .placeholder(errorImageId)
                                .fitCenter()  //让图片全充，
//                                .override(1400, 900)//设置图片宽高
                )
                .load(imageUrl)
                .into(imageView);
    }

    /**
     * 获取网络Bitmap
     *
     * @param context
     * @param url
     * @param callBack
     */
    public static void obtainBitmap(final Context context, final String url, final obtainBitmapListener callBack) {
        Glide.with(context).asBitmap().load(url).into(new Target<Bitmap>() {

            @Override
            public void onLoadStarted(Drawable placeholder) {
            }

            @Override
            public void onLoadFailed(@Nullable Drawable errorDrawable) {
                if (callBack != null) {
                    callBack.onObtainBitmapFailed();
                }
            }

            @Override
            public void onResourceReady(@NonNull Bitmap resource, @Nullable Transition<? super Bitmap> transition) {
                if (callBack != null && resource != null) {
                    callBack.onObtainBitmapSuccess(resource);
                } else {
                    callBack.onObtainBitmapFailed();
                }
            }

            @Override
            public void onLoadCleared(@Nullable Drawable placeholder) {
            }

            @Override
            public void getSize(SizeReadyCallback cb) {
            }

            @Override
            public void removeCallback(@NonNull SizeReadyCallback cb) {

            }

            @Override
            public void setRequest(Request request) {
            }

            @Override
            public Request getRequest() {
                return null;
            }

            @Override
            public void onStart() {
                LogUtil.d("obtainBitmap onStart");
            }

            @Override
            public void onStop() {
                LogUtil.d("obtainBitmap onStop");
            }

            @Override
            public void onDestroy() {
                LogUtil.d("obtainBitmap onDestroy");
            }
        });
    }

    public static Bitmap downBitmap(final Context context, final String url, int width, int height) {
        try {
            Bitmap myBitmap = Glide.with(context)
                    .asBitmap() //必须
                    .load(url)
                    .into(width, height)
                    .get();
            return myBitmap;
        } catch (InterruptedException e) {
            e.printStackTrace();
        } catch (ExecutionException e) {
            e.printStackTrace();
        }
        return null;
    }

    public interface obtainBitmapListener {
        void onObtainBitmapSuccess(Bitmap bitmap);

        void onObtainBitmapFailed();

        void onObtainBitmapCancel();
    }
}
