package com.gingersoft.gsa.cloud.database.bean;

import android.graphics.Color;

import org.greenrobot.greendao.annotation.Entity;
import org.greenrobot.greendao.annotation.Id;
import org.greenrobot.greendao.annotation.Property;
import java.util.Date;
import org.greenrobot.greendao.annotation.Generated;
import org.greenrobot.greendao.annotation.Transient;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-02-18
 * 修订历史：2020-02-18
 * 描述：套餐食品關係
 */
@Entity
public class ComboItem {

    /**
     * ID
     */
    @Property(nameInDb = "_id")
    @Id(autoincrement = true)
    private Long id;

    private Long comId;

    private Long fid;

    private Long qty;

    private Double diffAmt;

    private Long seqNo;

    private Long visible;

    private Date createTime;

    private String createBy;

    private Date updateTime;

    private Long conditions;

    private Long isRT;

    private Byte deletes;

    private Long posId;

    private Long restaurant_id;

    private Byte isMainAccount;


    /**
     * 自定義字段
     */
    @Transient
    private String name;
    @Transient
    private String name1;
    @Transient
    private String name2;
    @Transient
    private long parentId;
    /**
     * 價格
     */
    @Transient
    private double price = 0.00;
    /**
     * 是否自動展開
     */
    @Transient
    private int autoMode = 0;
    /**
     * 是否备注细项
     */
    @Transient
    private boolean isModifier;
    /**
     * 背景顏色
     */
    @Transient
    private int bgColor = Color.parseColor("#067878");
    /**
     * 字體顏色
     */
    @Transient
    private int fontColor = Color.parseColor("#FFFFFF");
    /**
     * 套餐細項
     */
    @Transient
    private Modifier modifier;



    @Generated(hash = 1857315418)
    public ComboItem(Long id, Long comId, Long fid, Long qty, Double diffAmt,
            Long seqNo, Long visible, Date createTime, String createBy,
            Date updateTime, Long conditions, Long isRT, Byte deletes, Long posId,
            Long restaurant_id, Byte isMainAccount) {
        this.id = id;
        this.comId = comId;
        this.fid = fid;
        this.qty = qty;
        this.diffAmt = diffAmt;
        this.seqNo = seqNo;
        this.visible = visible;
        this.createTime = createTime;
        this.createBy = createBy;
        this.updateTime = updateTime;
        this.conditions = conditions;
        this.isRT = isRT;
        this.deletes = deletes;
        this.posId = posId;
        this.restaurant_id = restaurant_id;
        this.isMainAccount = isMainAccount;
    }

    @Generated(hash = 435228340)
    public ComboItem() {
    }


    public Long getId() {
        return id;
    }

    public Long getComId() {
        return comId;
    }

    public Long getFid() {
        return fid;
    }

    public Long getQty() {
        return qty;
    }

    public Double getDiffAmt() {
        return diffAmt;
    }

    public Long getSeqNo() {
        return seqNo;
    }

    public Long getVisible() {
        return visible;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public String getCreateBy() {
        return createBy;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public Long getConditions() {
        return conditions;
    }

    public Long getIsRT() {
        return isRT;
    }

    public Byte getDeletes() {
        return deletes;
    }

    public Long getPosId() {
        return posId;
    }

    public Long getRestaurant_id() {
        return restaurant_id;
    }

    public Byte getIsMainAccount() {
        return isMainAccount;
    }

    public String getName() {
        return name;
    }

    public String getName1() {
        return name1;
    }

    public String getName2() {
        return name2;
    }

    public long getParentId() {
        return parentId;
    }

    public double getPrice() {
        return price;
    }

    public int getAutoMode() {
        return autoMode;
    }

    public boolean isModifier() {
        return isModifier;
    }

    public int getBgColor() {
        return bgColor;
    }

    public int getFontColor() {
        return fontColor;
    }

    public void setName1(String name1) {
        this.name1 = name1;
    }

    public void setName2(String name2) {
        this.name2 = name2;
    }

    public Modifier getModifier() {
        return modifier;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setComId(Long comId) {
        this.comId = comId;
    }

    public void setFid(Long fid) {
        this.fid = fid;
    }

    public void setQty(Long qty) {
        this.qty = qty;
    }

    public void setDiffAmt(Double diffAmt) {
        this.diffAmt = diffAmt;
    }

    public void setSeqNo(Long seqNo) {
        this.seqNo = seqNo;
    }

    public void setVisible(Long visible) {
        this.visible = visible;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public void setCreateBy(String createBy) {
        this.createBy = createBy;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public void setConditions(Long conditions) {
        this.conditions = conditions;
    }

    public void setIsRT(Long isRT) {
        this.isRT = isRT;
    }

    public void setDeletes(Byte deletes) {
        this.deletes = deletes;
    }

    public void setPosId(Long posId) {
        this.posId = posId;
    }

    public void setRestaurant_id(Long restaurant_id) {
        this.restaurant_id = restaurant_id;
    }

    public void setIsMainAccount(Byte isMainAccount) {
        this.isMainAccount = isMainAccount;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setParentId(long parentId) {
        this.parentId = parentId;
    }

    public void setPrice(double price) {
        this.price = price;
    }

    public void setAutoMode(int autoMode) {
        this.autoMode = autoMode;
    }

    public void setModifier(boolean modifier) {
        isModifier = modifier;
    }

    public void setBgColor(int bgColor) {
        this.bgColor = bgColor;
    }

    public void setFontColor(int fontColor) {
        this.fontColor = fontColor;
    }

    public void setModifier(Modifier modifier) {
        this.modifier = modifier;
    }

    public static ComboItem addFoodInfo(Food food, ComboItem foodCombo) {
        foodCombo.setName(food.getFoodName());
        foodCombo.setFid(food.getId());
        foodCombo.setPrice(food.getPrice());
        foodCombo.setAutoMode(food.getAutoMod());
        return foodCombo;
    }

}
