package com.gingersoft.supply_chain.mvp.bean;

import java.io.Serializable;
import java.util.List;

import lombok.Data;

/**
 * @author 宇航.
 * User: admin
 * Date: 2021/1/6
 * Time: 16:22
 * Use: 庫存查詢列表實體類
 */
@Data
public class WareHouseListBean {

    /**
     * success : true
     * sysTime : 1609921315071
     * data : {"total":{"overdue":0,"aboutExpire":0,"outStock":1,"cost":1067,"count":4},"purchaseWarehousingOrderDetailsVOS":[{"id":84,"name":"阿克苏苹果🍎","cateName":"特级水果","supplierName":"盒马生鲜","basicUnitName":"1","foodPrice":89,"foodNum":3,"foodAmount":267},{"id":67,"name":"大閘蟹","cateName":"海鮮","supplierName":"測試供應商1205","basicUnitName":"1","foodPrice":100,"foodNum":3,"foodAmount":300},{"id":66,"name":"澳洲龍蝦","cateName":"海鮮","supplierName":"測試供應商1205","basicUnitName":"1","foodPrice":100,"foodNum":3,"foodAmount":300},{"id":3,"name":"香蕉","cateName":"青菜","supplierName":"人民公社供應商","basicUnitName":"3","foodPrice":2,"foodNum":20,"foodAmount":200}]}
     */
    private String errMsg;
    private boolean success;
    private long sysTime;
    private WareHousingDataBean data;

    @Data
    public static class WareHousingDataBean {
        /**
         * total : {"overdue":0,"aboutExpire":0,"outStock":1,"cost":1067,"count":4}
         * purchaseWarehousingOrderDetailsVOS : [{"id":84,"name":"阿克苏苹果🍎","cateName":"特级水果","supplierName":"盒马生鲜","basicUnitName":"1","foodPrice":89,"foodNum":3,"foodAmount":267},{"id":67,"name":"大閘蟹","cateName":"海鮮","supplierName":"測試供應商1205","basicUnitName":"1","foodPrice":100,"foodNum":3,"foodAmount":300},{"id":66,"name":"澳洲龍蝦","cateName":"海鮮","supplierName":"測試供應商1205","basicUnitName":"1","foodPrice":100,"foodNum":3,"foodAmount":300},{"id":3,"name":"香蕉","cateName":"青菜","supplierName":"人民公社供應商","basicUnitName":"3","foodPrice":2,"foodNum":20,"foodAmount":200}]
         */
        private TotalBean total;
        private List<PurchaseWarehousingOrderDetailsVO> purchaseWarehousingOrderDetailsVOS;

        /**
         * 數量統計
         */
        @Data
        public static class TotalBean {
            /**
             * overdue : 0
             * aboutExpire : 0
             * outStock : 1
             * cost : 1067
             * count : 4
             */
            /**
             * 過期食材數量
             */
            private int overdue;
            /**
             * 即將過期食材數量
             */
            private int aboutExpire;
            /**
             * 低庫存
             */
            private int outStock;
            /**
             * 成本
             */
            private double cost;
            /**
             * 本次查詢數據條數
             */
            private int count;
        }

        /**
         * 食品信息
         */
        @Data
        public static class PurchaseWarehousingOrderDetailsVO implements Serializable {
            /**
             * id : 84
             * name : 阿克苏苹果🍎
             * cateName : 特级水果
             * supplierName : 盒马生鲜
             * basicUnitName : 1
             * foodPrice : 89
             * foodNum : 3
             * foodAmount : 267
             */
            private int id;
            private String foodNo;
            private String name;
            private String foodCategoryName;
//            private String supplierName;
            private String unitName;
            private double foodPrice;
            private int foodNum;
            private double foodAmount;
            private String images;
            private boolean snFood;
        }
    }
}
