package com.gingersoft.gsa.cloud.ui.adapter.bean;

import android.text.InputFilter;

import lombok.Data;

/**
 * @author 宇航.
 * User: admin
 * Date: 2020/11/25
 * Time: 14:15
 * Use: 多類型輸入
 */
@Data
public class MultiCheckInputBean extends MultiInputBean {

    private int iconId;
    /**
     * 是否是默認
     * true：隱藏複選框，顯示"默認"字
     * false：顯示複選框，隱藏"默認"字
     */
    private boolean isDefault;

    public MultiCheckInputBean(int itemType, String showTitle, boolean isRequired, String hintText, int iconId) {
        super(itemType, showTitle, isRequired, hintText);
        this.iconId = iconId;
    }

    public MultiCheckInputBean(int itemType, String showTitle, boolean isRequired, String hintText, int iconId, boolean isDefault) {
        super(itemType, showTitle, isRequired, hintText);
        this.iconId = iconId;
        this.isDefault = isDefault;
    }

    public MultiCheckInputBean(int itemType, String showTitle, boolean isRequired, String hintText) {
        super(itemType, showTitle, isRequired, hintText);
    }

    public MultiCheckInputBean(int itemType, String showTitle, boolean isRequired, String hintText, InputFilter[] inputFilters, int iconId, boolean isDefault) {
        super(itemType, showTitle, isRequired, hintText, inputFilters);
        this.iconId = iconId;
        this.isDefault = isDefault;
    }
}
