package com.gingersoft.gsa.cloud.table.mvp.ui.adapter.meal;

import android.content.Context;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.gingersoft.gsa.cloud.base.application.GsaCloudApplication;
import com.gingersoft.gsa.cloud.database.bean.Modifier;
import com.gingersoft.gsa.cloud.table.R;
import com.gingersoft.gsa.cloud.table.R2;
import com.jess.arms.base.BaseHolder;
import com.jess.arms.base.DefaultAdapter;
import com.jess.arms.utils.ArmsUtils;
import com.jess.arms.utils.DeviceUtils;

import java.util.List;

import butterknife.BindView;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2018/6/27
 * 修订历史：2018/6/27
 * 描述：
 */

public class ModifierAdapter extends DefaultAdapter<Modifier> {

    private Context mContext;

    private int ColWidth;
    private int ColHeight;
    private int FontSize;

    private int OrderNumberChildShowSize;
    private int OrderNumberChildFontSize;


    public ModifierAdapter(Context context, List<Modifier> infos) {
        super(infos);
        this.mContext = context;

        int ComboColCount = 4;
        int screenWidth = (int) DeviceUtils.getScreenWidth(context);
        ColWidth = ((screenWidth - ComboColCount) / ComboColCount);
        ColHeight = GsaCloudApplication.androidSetting.getModBtnHeight();
        FontSize = GsaCloudApplication.androidSetting.getModFontSize();
        OrderNumberChildShowSize = GsaCloudApplication.androidSetting.getOrderNumberChildShowSize();
        OrderNumberChildFontSize = GsaCloudApplication.androidSetting.getOrderNumberChildFontSize();
    }

    @Override
    public int getItemCount() {
        return mInfos.size();
    }

    @Override
    public BaseHolder<Modifier> getHolder(View v, int viewType) {
        return new ComboItemHolder(v);
    }

    @Override
    public int getLayoutId(int viewType) {
        return R.layout.meal_item_combo;
    }

    class ComboItemHolder extends BaseHolder<Modifier> {

        @BindView(R2.id.tv_name)
        TextView tv_name;
        @BindView(R2.id.tv_soldout)
        TextView tv_soldout;

        @BindView(R2.id.iv_qty_sold)
        ImageView iv_qty_sold;
        @BindView(R2.id.iv_return)
        ImageView iv_return;

        public ComboItemHolder(View itemView) {
            super(itemView);
        }

        @Override
        public void setData(Modifier datasBean, int position) {

            iv_qty_sold.setVisibility(View.INVISIBLE);
            tv_soldout.setVisibility(View.INVISIBLE);

            initModifierName(datasBean);
            initModifierSoldout(datasBean);
            initModifierLayoutParams();
            tv_name.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    if (mOnItemClickListener != null) {
                        mOnItemClickListener.onItemClick(datasBean, position);
                    }
                }
            });
        }

        private void initModifierName(Modifier datasBean) {
            String desc = datasBean.getModifierName();
//            switch (GSAApplication.androidSetting.getDataLanguage()) {
//                case 1:
//                    desc = datasBean.getDesc1();
//                    break;
//                case 2:
//                    desc = datasBean.getDesc2();
//                    break;
//                case 3:
//                    desc = datasBean.getDesc3();
//                    break;
//            }
//            if (desc == null || desc.trim().length() == 0) {
//                desc = datasBean.getDesc1();
//            }
            tv_name.setText(desc);

//            com.elegant.bin.gsa.mvp.main.model.bean.Color.DatasBean bgAndFontColor = datasBean.getBgAndFontColor();
//            if (bgAndFontColor != null) {
//                if (!TextUtils.isEmpty(bgAndFontColor.getAndroidColor())) {
//                    tv_name.setBackgroundColor(Color.parseColor(bgAndFontColor.getAndroidColor()));
//                } else {
            tv_name.setBackgroundColor(ArmsUtils.getColor(mContext, R.color.keyboard_paybill_normal));
//                }
//                if (!TextUtils.isEmpty(bgAndFontColor.getAndroidfontcolor())) {
//                    tv_name.setTextColor(Color.parseColor(bgAndFontColor.getAndroidfontcolor()));
//                } else {
            tv_name.setTextColor(ArmsUtils.getColor(mContext, R.color.theme_white_color));
//                }
//            }

//            tv_name.setHeight(ColHeight);
//            tv_name.setWidth(ColWidth);
//            tv_name.setMaxWidth(ColHeight);
//            tv_name.setMinWidth(ColWidth);
            tv_name.setGravity(Gravity.CENTER);

            tv_name.setTextSize(FontSize);
        }

        private void initModifierSoldout(Modifier datasBean) {

//            if (datasBean.isSoldout()) {
//                iv_qty_sold.setVisibility(View.VISIBLE);
//            } else {
//                iv_qty_sold.setVisibility(View.INVISIBLE);
//            }

//            int maxNumber = datasBean.getMaxNumber();
//            int number = datasBean.getNumber();
//            if (number >= maxNumber) {
//                tv_soldout.setVisibility(View.VISIBLE);
//                tv_soldout.setText(maxNumber);
//            } else {
//                tv_soldout.setVisibility(View.INVISIBLE);
//            }

            String qty = datasBean.getMaxNumber();
            if (qty.equals("")) {
                tv_soldout.setVisibility(View.INVISIBLE);
            } else {
                tv_soldout.setVisibility(View.VISIBLE);
                tv_soldout.setText(datasBean.getMaxNumber());
            }

            tv_soldout.setMaxHeight(OrderNumberChildShowSize);
            tv_soldout.setMinHeight(OrderNumberChildShowSize);
            tv_soldout.setTextSize(OrderNumberChildFontSize);
        }

        private void initModifierLayoutParams() {
            ViewGroup.LayoutParams layoutParams = tv_name.getLayoutParams();
            //这里减2 减去分割线宽度
            layoutParams.width = ColWidth - 4;
            layoutParams.height = ColHeight;
            tv_name.setLayoutParams(layoutParams);
        }
    }

    private OnItemClickListener mOnItemClickListener;

    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        mOnItemClickListener = onItemClickListener;
    }

    public interface OnItemClickListener {

        void onItemClick(Modifier datasBean, int position);

    }
}
