package com.gingersoft.gsa.other_order_mode.data

import com.gingersoft.gsa.other_order_mode.data.model.bean.ThirdItem
import com.gingersoft.gsa.other_order_mode.data.network.CoolWeatherNetwork
import com.google.gson.Gson
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.withContext
import okhttp3.FormBody

class WeatherRepository private constructor(private val network: CoolWeatherNetwork) {


    suspend fun requestOrderList(restaurantId: String, status: String, type: String, page: String, orderNo: String, phone: String) = withContext(Dispatchers.IO) {
        val requestBody = FormBody.Builder()
                .add("restaurantId", restaurantId)
                .add("page", page)
                .add("status", status)
                .add("orderNo", orderNo)
                .add("phone", phone)
                .add("type", type)
                .build()
        val heWeather = network.fetchOrderList(requestBody)
        heWeather
    }

    suspend fun updateRestOpenStatus(state: Boolean, restaurantId: String) = withContext(Dispatchers.IO) {
        val requestBody = FormBody.Builder()
                .add("restId", restaurantId)
                .add("openStatus", if (state) "1" else "2")
                .build()
        val data = network.updateRestOpenStatus(requestBody)
        data
    }

    suspend fun getOrderInfo(orderId: String) = withContext(Dispatchers.IO) {
        val requestBody = FormBody.Builder()
                .add("orderId", orderId)
                .build()
        val data = network.getOrderInfo(requestBody)
        data
    }

    suspend fun updateOrderStatus(orderId: String, selfOrderId: String?, status: Int, mobile: String?, sender: String?, isPush: Int, orderType: Int) = withContext(Dispatchers.IO) {
        val requestBody = FormBody.Builder()
                .add("orderId", orderId)
                .add("selfOrderId", selfOrderId)
                .add("status", status.toString())
                .add("mobile", mobile)
                .add("sender", sender)
                .add("isPush", isPush.toString())//1送貨  2確認訂單  結賬傳0
                .add("orderType", orderType.toString())
                .build()
        val data = network.updateOrderStatus(requestBody)
        data
    }

    suspend fun thirdDelivery(orderId: String, thirdItem: ThirdItem) = withContext(Dispatchers.IO) {
        val requestBody = FormBody.Builder()
                .add("orderId", orderId)
                .add("items", Gson().toJson(thirdItem))
                .build()
        network.thirdDelivery(requestBody)
    }

    suspend fun updateSelfOrderStatus(ids: String, status: String, restaurantId: String) = withContext(Dispatchers.IO) {
        val requestBody = FormBody.Builder()
                .add("ids", ids)
                .add("status", status)
                .add("restaurantId", restaurantId)
                .build()
        val data = network.updateSelfOrderStatus(requestBody)
        data
    }


    suspend fun getDeliveryInfo(restId: String, userId: String) = withContext(Dispatchers.IO) {
        val requestBody = FormBody.Builder()
                .add("restId", restId)
                .add("userId", userId)
                .build()
        val data = network.getDeliveryInfo(requestBody)
        data
    }

    suspend fun getDeliveryConfigDTO(restaurantId: String) = withContext(Dispatchers.IO) {
        val requestBody = FormBody.Builder()
                .add("restaurantId", restaurantId)
                .build()
        network.getDeliveryConfigDTO(requestBody)
    }

    companion object {
        private lateinit var instance: WeatherRepository

        fun getInstance(network: CoolWeatherNetwork): WeatherRepository {
            if (!::instance.isInitialized) {
                synchronized(WeatherRepository::class.java) {
                    if (!::instance.isInitialized) {
                        instance = WeatherRepository(network)
                    }
                }
            }
            return instance
        }

    }

}