package com.gingersoft.gsa.cloud.database.greendao;

import java.util.Map;

import org.greenrobot.greendao.AbstractDao;
import org.greenrobot.greendao.AbstractDaoSession;
import org.greenrobot.greendao.database.Database;
import org.greenrobot.greendao.identityscope.IdentityScopeType;
import org.greenrobot.greendao.internal.DaoConfig;

import com.gingersoft.gsa.cloud.database.bean.ComboItem;
import com.gingersoft.gsa.cloud.database.bean.Discount;
import com.gingersoft.gsa.cloud.database.bean.Food;
import com.gingersoft.gsa.cloud.database.bean.FoodCombo;
import com.gingersoft.gsa.cloud.database.bean.FoodModifier;
import com.gingersoft.gsa.cloud.database.bean.Function;
import com.gingersoft.gsa.cloud.database.bean.Modifier;
import com.gingersoft.gsa.cloud.database.bean.PrinterDeviceBean;
import com.gingersoft.gsa.cloud.database.bean.ExpandInfo;

import com.gingersoft.gsa.cloud.database.greendao.ComboItemDao;
import com.gingersoft.gsa.cloud.database.greendao.DiscountDao;
import com.gingersoft.gsa.cloud.database.greendao.FoodDao;
import com.gingersoft.gsa.cloud.database.greendao.FoodComboDao;
import com.gingersoft.gsa.cloud.database.greendao.FoodModifierDao;
import com.gingersoft.gsa.cloud.database.greendao.FunctionDao;
import com.gingersoft.gsa.cloud.database.greendao.ModifierDao;
import com.gingersoft.gsa.cloud.database.greendao.PrinterDeviceBeanDao;
import com.gingersoft.gsa.cloud.database.greendao.ExpandInfoDao;

// THIS CODE IS GENERATED BY greenDAO, DO NOT EDIT.

/**
 * {@inheritDoc}
 * 
 * @see org.greenrobot.greendao.AbstractDaoSession
 */
public class DaoSession extends AbstractDaoSession {

    private final DaoConfig comboItemDaoConfig;
    private final DaoConfig discountDaoConfig;
    private final DaoConfig foodDaoConfig;
    private final DaoConfig foodComboDaoConfig;
    private final DaoConfig foodModifierDaoConfig;
    private final DaoConfig functionDaoConfig;
    private final DaoConfig modifierDaoConfig;
    private final DaoConfig printerDeviceBeanDaoConfig;
    private final DaoConfig expandInfoDaoConfig;

    private final ComboItemDao comboItemDao;
    private final DiscountDao discountDao;
    private final FoodDao foodDao;
    private final FoodComboDao foodComboDao;
    private final FoodModifierDao foodModifierDao;
    private final FunctionDao functionDao;
    private final ModifierDao modifierDao;
    private final PrinterDeviceBeanDao printerDeviceBeanDao;
    private final ExpandInfoDao expandInfoDao;

    public DaoSession(Database db, IdentityScopeType type, Map<Class<? extends AbstractDao<?, ?>>, DaoConfig>
            daoConfigMap) {
        super(db);

        comboItemDaoConfig = daoConfigMap.get(ComboItemDao.class).clone();
        comboItemDaoConfig.initIdentityScope(type);

        discountDaoConfig = daoConfigMap.get(DiscountDao.class).clone();
        discountDaoConfig.initIdentityScope(type);

        foodDaoConfig = daoConfigMap.get(FoodDao.class).clone();
        foodDaoConfig.initIdentityScope(type);

        foodComboDaoConfig = daoConfigMap.get(FoodComboDao.class).clone();
        foodComboDaoConfig.initIdentityScope(type);

        foodModifierDaoConfig = daoConfigMap.get(FoodModifierDao.class).clone();
        foodModifierDaoConfig.initIdentityScope(type);

        functionDaoConfig = daoConfigMap.get(FunctionDao.class).clone();
        functionDaoConfig.initIdentityScope(type);

        modifierDaoConfig = daoConfigMap.get(ModifierDao.class).clone();
        modifierDaoConfig.initIdentityScope(type);

        printerDeviceBeanDaoConfig = daoConfigMap.get(PrinterDeviceBeanDao.class).clone();
        printerDeviceBeanDaoConfig.initIdentityScope(type);

        expandInfoDaoConfig = daoConfigMap.get(ExpandInfoDao.class).clone();
        expandInfoDaoConfig.initIdentityScope(type);

        comboItemDao = new ComboItemDao(comboItemDaoConfig, this);
        discountDao = new DiscountDao(discountDaoConfig, this);
        foodDao = new FoodDao(foodDaoConfig, this);
        foodComboDao = new FoodComboDao(foodComboDaoConfig, this);
        foodModifierDao = new FoodModifierDao(foodModifierDaoConfig, this);
        functionDao = new FunctionDao(functionDaoConfig, this);
        modifierDao = new ModifierDao(modifierDaoConfig, this);
        printerDeviceBeanDao = new PrinterDeviceBeanDao(printerDeviceBeanDaoConfig, this);
        expandInfoDao = new ExpandInfoDao(expandInfoDaoConfig, this);

        registerDao(ComboItem.class, comboItemDao);
        registerDao(Discount.class, discountDao);
        registerDao(Food.class, foodDao);
        registerDao(FoodCombo.class, foodComboDao);
        registerDao(FoodModifier.class, foodModifierDao);
        registerDao(Function.class, functionDao);
        registerDao(Modifier.class, modifierDao);
        registerDao(PrinterDeviceBean.class, printerDeviceBeanDao);
        registerDao(ExpandInfo.class, expandInfoDao);
    }
    
    public void clear() {
        comboItemDaoConfig.clearIdentityScope();
        discountDaoConfig.clearIdentityScope();
        foodDaoConfig.clearIdentityScope();
        foodComboDaoConfig.clearIdentityScope();
        foodModifierDaoConfig.clearIdentityScope();
        functionDaoConfig.clearIdentityScope();
        modifierDaoConfig.clearIdentityScope();
        printerDeviceBeanDaoConfig.clearIdentityScope();
        expandInfoDaoConfig.clearIdentityScope();
    }

    public ComboItemDao getComboItemDao() {
        return comboItemDao;
    }

    public DiscountDao getDiscountDao() {
        return discountDao;
    }

    public FoodDao getFoodDao() {
        return foodDao;
    }

    public FoodComboDao getFoodComboDao() {
        return foodComboDao;
    }

    public FoodModifierDao getFoodModifierDao() {
        return foodModifierDao;
    }

    public FunctionDao getFunctionDao() {
        return functionDao;
    }

    public ModifierDao getModifierDao() {
        return modifierDao;
    }

    public PrinterDeviceBeanDao getPrinterDeviceBeanDao() {
        return printerDeviceBeanDao;
    }

    public ExpandInfoDao getExpandInfoDao() {
        return expandInfoDao;
    }

}
