package com.gingersoft.gsa.cloud.base.utils;

import android.util.SparseArray;

import com.gingersoft.gsa.cloud.database.bean.FoodCombo;
import com.gingersoft.gsa.cloud.database.bean.Modifier;

import java.util.List;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-02-14
 * 修订历史：2020-02-14
 * 描述：常用配置
 */
public class CommonConfiguration {

    //保存食品套餐組ID
    private SparseArray<Integer> mComboIdList;
    //保存細項組ID
    private SparseArray<Long> mModifierTopIdList;

    private static CommonConfiguration commonConfiguration;

    public static CommonConfiguration getInstance() {
        if (commonConfiguration == null) {
            commonConfiguration = new CommonConfiguration();
        }
        return commonConfiguration;
    }

    public CommonConfiguration() {
        mComboIdList = new SparseArray<>();
        mModifierTopIdList = new SparseArray<>();
    }

    /**
     * 保存食品對應套餐ID備用
     *
     * @param datas
     */
    public void saveComboIdConfiguration(List<FoodCombo> datas) {
        for (FoodCombo datasBean : datas) {
            if (datasBean.getFid() != 0 && datasBean.getComId() != 0) {
                mComboIdList.put(Integer.parseInt(datasBean.getFid() + ""), datasBean.getComId());
            }
        }
    }

    /**
     * 保存細項對應組ID備用
     *
     * @param datas
     */
    public void saveModifierTopIdConfiguration(List<Modifier> datas) {
        for (Modifier datasBean : datas) {
            if (datasBean.getTopId() != null && datasBean.getMid() != 0 && datasBean.getTopId() != 0) {
                mModifierTopIdList.put(Integer.parseInt(datasBean.getMid() + ""), datasBean.getTopId());
            }
        }
    }

    public long getModifierTopIdMid(int mid) {
        return mModifierTopIdList.get(mid, (long) 0);
    }
}
