package com.gingersoft.gsa.cloud.ui.utils;

import android.app.Dialog;
import android.content.Context;
import android.view.View;

import com.gingersoft.gsa.cloud.base.R;
import com.gingersoft.gsa.cloud.base.widget.DialogUtils;

public class AppDialog {

    public void showWaringDialog(Context context, String title, DialogOnClickListenter sureOnclickListenter) {
        showWaringDialog(context, title, null, null, sureOnclickListenter, null);
    }

//    public static void showWaringDialog(Context context, String title, DialogOnClickListenter sureOnclickListenter) {
//        showWaringDialog(context, title, null, null, sureOnclickListenter, null);
//    }

    private void showWaringDialog(Context context, String title, String confimText, String cancelText, DialogOnClickListenter sureOnclickListenter, DialogOnClickListenter cancelOnclickListenter) {
        //暫停接單，彈窗向用戶確認是否關閉
        new DialogUtils(context, R.layout.other_order_pause_orders) {
            @Override
            public void initLayout(ViewHepler hepler, Dialog dialog) {
                if (title != null)
                    hepler.setText(R.id.tv_warning_title, title);
                if (confimText != null)
                    hepler.setText(R.id.tv_dialog_confirm, confimText);
                if (sureOnclickListenter != null) {
                    hepler.getView(R.id.tv_dialog_confirm).setOnClickListener(v -> sureOnclickListenter.onclick(v, dialog));
                }
                if (cancelText != null)
                    hepler.setText(R.id.tv_dialog_cancel, cancelText);
                if (cancelOnclickListenter != null)
                    hepler.getView(R.id.tv_dialog_cancel).setOnClickListener(v -> cancelOnclickListenter.onclick(v, dialog));
                else
                    hepler.getView(R.id.tv_dialog_cancel).setOnClickListener(v -> dialog.dismiss());
            }
        }.show();
    }


    public interface DialogOnClickListenter {
        void onclick(View view, Dialog dialog);
    }

}
