package com.gingersoft.gsa.cloud.login.mvp.ui.activity.mvp.ui.activity;

import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.ScaleAnimation;
import android.widget.RelativeLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.viewpager2.widget.ViewPager2;

import com.gingersoft.gsa.cloud.base.utils.encryption.Aes;
import com.gingersoft.gsa.cloud.base.utils.other.SPUtils;
import com.gingersoft.gsa.cloud.constans.UserConstans;
import com.gingersoft.gsa.cloud.login.R;
import com.gingersoft.gsa.cloud.login.R2;
import com.gingersoft.gsa.cloud.login.di.component.DaggerWelcomeComponent;
import com.gingersoft.gsa.cloud.login.di.module.WelcomeModule;
import com.gingersoft.gsa.cloud.login.mvp.bean.GuideBean;
import com.gingersoft.gsa.cloud.login.mvp.contract.LoginInterfaceImpl;
import com.gingersoft.gsa.cloud.login.mvp.contract.WelcomeContract;
import com.gingersoft.gsa.cloud.login.mvp.presenter.WelcomePresenter;
import com.gingersoft.gsa.cloud.login.mvp.ui.adapter.GuideAdapter;
import com.gingersoft.gsa.cloud.ui.bean.mode.BrandsBean;
import com.gingersoft.gsa.cloud.ui.bean.mode.LoginBean;
import com.gingersoft.gsa.cloud.ui.widget.Indicator.UIndicator;
import com.gingersoft.gsa.cloud.ui.widget.dialog.ChooseRestaurantDialog;
import com.jess.arms.di.component.AppComponent;
import com.jess.arms.utils.ArmsUtils;

import java.util.ArrayList;
import java.util.List;

import butterknife.BindView;
import butterknife.OnClick;

import static com.jess.arms.utils.Preconditions.checkNotNull;


public class WelcomeActivity extends LoginInterfaceImpl<WelcomePresenter> implements WelcomeContract.View, View.OnClickListener {
    @BindView(R2.id.content_view)
    RelativeLayout contentView;
    @BindView(R2.id.cl_guide_layout)
    ConstraintLayout guideView;
    @BindView(R2.id.vp2_guide)
    ViewPager2 mVpGuide;

    @BindView(R2.id.guide_magic_indicator)
    UIndicator magicIndicator;

    @BindView(R2.id.tv_guide_title)
    TextView mTvGuideTitle;
    @BindView(R2.id.tv_guide_details)
    TextView mTvGuideDetails;
    @BindView(R2.id.tv_experience)
    TextView mTvExperience;
    List<GuideBean> guideBeanList = new ArrayList<>();

    private final long ANIMATION_TIME = 1300;

    @Override
    public void setupActivityComponent(@NonNull AppComponent appComponent) {
        DaggerWelcomeComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .welcomeModule(new WelcomeModule(this))
                .build()
                .inject(this);
    }

    @Override
    public int initView(@Nullable Bundle savedInstanceState) {
        return R.layout.activity_welcome; //如果你不需要框架帮你设置 setContentView(id) 需要自行设置,请返回 0
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {
        ScaleAnimation animation = new ScaleAnimation(1.0f, 1.06f, 1.0f, 1.06f, Animation.RELATIVE_TO_SELF, 0.5f, Animation.RELATIVE_TO_SELF, 0.5f);
        animation.setDuration(2000);
        animation.setFillAfter(true);
        contentView.setAnimation(animation);
        animation.setAnimationListener(new Animation.AnimationListener() {
            @Override
            public void onAnimationStart(Animation animation) {

            }

            @Override
            public void onAnimationEnd(Animation animation) {
                if ((boolean) SPUtils.get(mContext, UserConstans.IS_GUIDE, true)) {
                    //是第一次進入，顯示引導頁
                    showGuide();
                } else {
                    if ((boolean) SPUtils.get(mContext, UserConstans.AUTO_LOGIN, false)) {
                        //自動登陸
                        String pwd = Aes.aesDecrypt((String) SPUtils.get(mContext, UserConstans.LOGIN_PASSWORD, ""));
                        mPresenter.login(SPUtils.get(mContext, UserConstans.LOGIN_USERNAME, "") + "", pwd);
                    } else {
                        killMyself();
                        startActivity(new Intent(mContext, LoginActivity.class));
                    }
                }
            }

            @Override
            public void onAnimationRepeat(Animation animation) {

            }
        });
        guideBeanList.add(new GuideBean("多終端雲同步，輕鬆管理所有", "為您搭建優良高效管理平台", getResources().getDrawable(R.mipmap.pic_guide_one)));
        guideBeanList.add(new GuideBean("數據分析可視化", "數據統計一目了然，直觀看到數據變化趨勢", getResources().getDrawable(R.mipmap.pic_guide_two)));
        guideBeanList.add(new GuideBean("多種點餐方式", "提供方便快捷的點餐服務，減低落錯單機會", getResources().getDrawable(R.mipmap.pic_guide_three)));
        GuideAdapter adapter = new GuideAdapter(mContext, guideBeanList);
        mVpGuide.setAdapter(adapter);
        //设置一个缩放动画
        mVpGuide.setPageTransformer(mAnimator);
        mVpGuide.registerOnPageChangeCallback(new ViewPager2.OnPageChangeCallback() {
            @Override
            public void onPageSelected(int position) {
                super.onPageSelected(position);
                updateUI(position);
                if (++position == guideBeanList.size() && mTvExperience.getVisibility() != View.VISIBLE) {
                    //當前選中最後一個page，顯示進入按鈕
                    mTvExperience.setVisibility(View.VISIBLE);
//                    mTvExperience.startAnimation(animation);
                }
            }
        });

        mVpGuide.setScrollBarFadeDuration((int) ANIMATION_TIME);
        magicIndicator.attachToViewPager(mVpGuide);
    }

    private void updateUI(int position) {
        mTvGuideTitle.setText(guideBeanList.get(position).getTitle());
        mTvGuideDetails.setText(guideBeanList.get(position).getDetails());
        setAnimator();
    }

    private void setAnimator() {
        ObjectAnimator translationAnim = ObjectAnimator.ofFloat(mTvGuideTitle, "translationX", -120f, 0f);
        translationAnim.setDuration(ANIMATION_TIME);
        translationAnim.setInterpolator(new DecelerateInterpolator());

        ObjectAnimator translationAnim2 = ObjectAnimator.ofFloat(mTvGuideDetails, "translationX", -120f, 0f);
        translationAnim2.setDuration(ANIMATION_TIME);
        translationAnim2.setInterpolator(new DecelerateInterpolator());

        ObjectAnimator alphaAnimator = ObjectAnimator.ofFloat(mTvGuideTitle, "alpha", 0f, 1f);
        alphaAnimator.setDuration(ANIMATION_TIME);

        ObjectAnimator alphaAnimator1 = ObjectAnimator.ofFloat(mTvGuideDetails, "alpha", 0f, 1f);
        alphaAnimator1.setDuration(ANIMATION_TIME);

        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(translationAnim, alphaAnimator, translationAnim2, alphaAnimator1);
        animatorSet.start();
    }

    /**
     * 顯示引導圖
     */
    private void showGuide() {
        Animation hideAnim = AnimationUtils.loadAnimation(mContext, R.anim.anim_alpha_hide);
        hideAnim.setAnimationListener(new Animation.AnimationListener() {
            @Override
            public void onAnimationStart(Animation animation) {
                guideView.startAnimation(AnimationUtils.loadAnimation(mContext, R.anim.anim_alpha_show));
                guideView.setVisibility(View.VISIBLE);
            }

            @Override
            public void onAnimationEnd(Animation animation) {
                contentView.setVisibility(View.GONE);
                guideView.setVisibility(View.VISIBLE);
            }

            @Override
            public void onAnimationRepeat(Animation animation) {

            }
        });
        contentView.startAnimation(hideAnim);
    }

    ViewPager2.PageTransformer mAnimator = (page, position) -> {
        Float absPos = Math.abs(position);
        Float scaleX;
        Float scaleY;
        if (absPos > 1) {
            scaleX = 0F;
            scaleY = 0F;
        } else {
            scaleX = 1 - absPos;
            scaleY = 1 - absPos;
        }
        page.setScaleX(scaleX);
        page.setScaleY(scaleY);
//        page.setRotationX(scaleX);
    };


    @Override
    public void initIntent() {

    }

    @Override
    public void initTopBar() {

    }

    @Override
    public void initLanguage() {

    }

    @Override
    public void initLayoutParams() {

    }

    @Override
    public void initLayoutVisible() {

    }


    @Override
    public void showLoading(String message) {

    }

    @Override
    public void hideLoading() {

    }

    @Override
    public void showMessage(@NonNull String message) {
        checkNotNull(message);
        ArmsUtils.makeText(this, message);
    }

    @Override
    public void launchActivity(@NonNull Intent intent) {
        checkNotNull(intent);
        ArmsUtils.startActivity(intent);
    }

    @Override
    public void killMyself() {
        finish();
    }

    @Override
    public void loginSuccess(LoginBean info) {
        super.loginSuccess(info);
//        finish();
    }

    private boolean isChooseRestaurant = false;

    @Override
    public void showChooseRestaurantDialog(List<BrandsBean.BrandsData> brandsBeans, List<BrandsBean.BrandsData> brands) {
        new ChooseRestaurantDialog.BottomListSheetBuilder(mContext)
                .addBrandItems(brandsBeans)
                .setOnItemClickListener((dialog, item, position) -> {
                    isChooseRestaurant = true;
                    ChooseRestaurantItemClick(brands, dialog, item);
                })
                .setOnDismissListener(dialog -> {
                    if (!isChooseRestaurant) {
                        //沒有選擇餐廳，就回到登陸頁面
                        startActivity(new Intent(mContext, LoginActivity.class));
                    }
                    killMyself();
                })
                .build()
                .show();
    }

    @OnClick({R2.id.iv_guide_close, R2.id.tv_experience})
    @Override
    public void onClick(View v) {
        if (v.getId() == R.id.iv_guide_close || v.getId() == R.id.tv_experience) {
            //去登陸頁，設置下次不顯示引導頁
            //立即體驗
            SPUtils.put(mContext, UserConstans.IS_GUIDE, false);
            startActivity(new Intent(mContext, LoginActivity.class));
            killMyself();
        }
    }
}
