package com.gingersoft.gsa.other_order_mode.data.network

import com.gingersoft.gsa.cloud.base.application.GsaCloudApplication
import com.gingersoft.gsa.cloud.base.utils.encryption.Aes
import com.gingersoft.gsa.cloud.constans.AppConstans
import com.gingersoft.gsa.cloud.constans.HttpsConstans
import com.gingersoft.gsa.cloud.globalconfig.applyOptions.intercept.LoggingInterceptor
import com.jess.arms.utils.DeviceUtils
import okhttp3.Headers
import okhttp3.Interceptor
import okhttp3.OkHttpClient
import okhttp3.Response
import retrofit2.Retrofit
import retrofit2.converter.gson.GsonConverterFactory
import retrofit2.converter.scalars.ScalarsConverterFactory
import java.io.IOException
import java.util.concurrent.TimeUnit

object ServiceCreator {

    private val httpClient = OkHttpClient.Builder()
            .connectTimeout(15, TimeUnit.SECONDS)
            .addInterceptor(LoggingInterceptor())
            .addInterceptor(UserAgentIntercepter())

    var ROOT_URL: String = HttpsConstans.ROOT_URL
    var CLOUD_BASE_URL: String = HttpsConstans.ROOT_SERVER_ADDRESS_FORMAL

    private var BASE_URL = "$ROOT_URL/ricepon-wechat/api/"
    private var BASE_URL2 = "$ROOT_URL/member-web/api/"
    private var BASE_URL3 = "$ROOT_URL/member-web/ricepon-gsa/api/"
    private val builder = Retrofit.Builder()
            .baseUrl(BASE_URL)
            .client(httpClient.build())
            .addConverterFactory(ScalarsConverterFactory.create())
            .addConverterFactory(GsonConverterFactory.create())

    private val builder2 = Retrofit.Builder()
            .baseUrl(BASE_URL2)
            .client(httpClient.build())
            .addConverterFactory(ScalarsConverterFactory.create())
            .addConverterFactory(GsonConverterFactory.create())

    private val builder3 = Retrofit.Builder()
            .baseUrl(BASE_URL3)
            .client(httpClient.build())
            .addConverterFactory(ScalarsConverterFactory.create())
            .addConverterFactory(GsonConverterFactory.create())

    private val builder4 = Retrofit.Builder()
            .baseUrl(CLOUD_BASE_URL)
            .client(httpClient.build())
            .addConverterFactory(ScalarsConverterFactory.create())
            .addConverterFactory(GsonConverterFactory.create())

    fun <T> create(serviceClass: Class<T>): T = builder.build().create(serviceClass)

    fun <T> create2(serviceClass: Class<T>): T = builder2.build().create(serviceClass)

    fun <T> create3(serviceClass: Class<T>): T = builder3.build().create(serviceClass)

    fun <T> create4(serviceClass: Class<T>): T = builder4.build().create(serviceClass)

    /**
     * 添加请求头
     */
    class UserAgentIntercepter : Interceptor {
        @Throws(IOException::class)
        override fun intercept(chain: Interceptor.Chain): Response {
            val request = chain.request()
            val headers = request.headers()

            val builder = Headers.Builder()
            for (i in 0 until headers.size()) {
                builder.set(headers.name(i), headers.value(i))
            }

            builder.set("mobileVersion", android.os.Build.VERSION.RELEASE)//set表示name1是唯一的，会覆盖掉已经存在的，add不会覆盖已经存在的头，可以存在多个
            builder.set("mobielModel", android.os.Build.MODEL)
            builder.set("apptype", AppConstans.APP_TYPE)
            builder.set("appinfo", DeviceUtils.getVersionName(GsaCloudApplication.getAppContext()))
            builder.set("mobileId", "1")

            if (GsaCloudApplication.isLogin) {
                var token: String
                val memberId = GsaCloudApplication.getMemberId(GsaCloudApplication.getAppContext())
                val loginToken = GsaCloudApplication.getLoginToken(GsaCloudApplication.getAppContext())
                token = Aes.aesEncrypt("9_" + memberId + "_" + System.currentTimeMillis() + "_" + loginToken)
                token = token.replace("\r|\n".toRegex(), "")
                builder.set("token", token)
            }
            val request1 = chain.request().newBuilder().headers(builder.build()).build()
            return chain.proceed(request1)
        }
    }
}