package com.joe.print.mvp.print;

import com.gingersoft.gsa.cloud.print.PrintDataMaker;
import com.gingersoft.gsa.cloud.print.PrinterWriter;
import com.gingersoft.gsa.cloud.print.PrinterWriterExecutor;
import com.joe.print.mvp.model.bean.PrintInfoBean;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by Wyh on 2020/1/9.
 * ip打印類
 */
public class TestPrintMaker implements PrintDataMaker {

    private PrinterWriter printer;
    private List<PrintInfoBean> printInfoBeans;

    public TestPrintMaker(PrinterWriter printer, List<PrintInfoBean> printInfoBeans) {
        this.printer = printer;
        this.printInfoBeans = printInfoBeans;
    }

    @Override
    public List<byte[]> getPrintData() {
        ArrayList<byte[]> data = new ArrayList<>();
        try {
            for (PrintInfoBean printInfoBean : printInfoBeans) {
                if (printInfoBean.getGravity() == 0) {
                    printer.setAlignLeft();
                }
                if (printInfoBean.getGravity() == 1) {
                    printer.setAlignCenter();
                }
                if (printInfoBean.getGravity() == 2) {
                    printer.setAlignRight();
                }
                if(printInfoBean.getSize().length > 1){
                    //如果打印多列內容，並且字體大小配置多個，則每一列取自己對應的字體大小
                    for (int i = 0; i < printInfoBean.getSize().length; i++) {
                        //打印多列
                        if (printInfoBean.getIsBold()[i]) {
                            printer.setEmphasizedOn();
                        } else {
                            printer.setEmphasizedOff();
                        }
                        printer.setFontSize(printInfoBean.getSize()[i]);
                        printer.print(printInfoBean.getContent()[i]);
                    }
                } else {
                    if(printInfoBean.getContent().length == 1){
                        //如果只打印一列內容，則字體大小只取size數組的第一個
                        if (printInfoBean.getIsBold()[0]) {
                            printer.setEmphasizedOn();
                        } else {
                            printer.setEmphasizedOff();
                        }
                        printer.setFontSize(printInfoBean.getSize()[0]);
                        printer.print(printInfoBean.getContent()[0]);
                    }
                }
                printer.print("\n");
            }
            printer.printLineFeed();
            printer.printLineFeed();
            printer.feedPaperCutPartial();
            data.add(printer.getDataAndReset());
            data.add(printer.getDataAndClose());
            return data;
        } catch (Exception e) {
            return new ArrayList<>();
        }
    }
}
