package com.gingersoft.gsa.cloud.bean;

import lombok.Data;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2018/8/11
 * 修订历史：2018/8/11
 * 描述：保存餐廳UI配置信息
 */
@Data
public class RestaurantExpandInfo {

    @Data
    public static final class UIStyleConfiguration {
        /**
         * 食品組、食品、細項、折扣行列寬高
         */
        private int foodGroupRow = 2;
        private int foodGroupColumn = 6;
        private int foodColumn = 4;
        private int comboColumn = 4;
        private int modColumn = 4;
        private int discountColumn = 4;
        /**
         * 食品組、食品、細項、折扣Item高度
         */
        private int foodGroupBtnHeight = 150;
        private int foodBtnHeight = 120;
        private int modBtnHeight = 80;
        private int comboHeight = 90;
        private int discountHeight = 80;

        private int LayoutQtyHeight = 40;
        /**
         * 食品組、食品、細項、折扣字體大小
         */
        private int foodGroupFontSize = 14;
        private int foodFontSize = 14;
        private int comboFontSize = 12;
        private int modFontSize = 12;
        private int discountFontSize = 12;

        private int OrderNumberShowSize = 20;
        private int OrderNumberFontSize = 7;
        private int OrderNumberChildShowSize = 20;
        private int OrderNumberChildFontSize = 10;

        //估清控制食品字體大小
        private int soldoutCtrlFoodFontSize = 16;

        public int getFoodGroupRow() {
            return foodGroupRow;
        }

        public void setFoodGroupRow(int foodGroupRow) {
            this.foodGroupRow = foodGroupRow;
        }

        public int getFoodGroupColumn() {
            return foodGroupColumn;
        }

        public void setFoodGroupColumn(int foodGroupColumn) {
            this.foodGroupColumn = foodGroupColumn;
        }

        public int getFoodColumn() {
            return foodColumn;
        }

        public void setFoodColumn(int foodColumn) {
            this.foodColumn = foodColumn;
        }

        public int getComboColumn() {
            return comboColumn;
        }

        public void setComboColumn(int comboColumn) {
            this.comboColumn = comboColumn;
        }

        public int getModColumn() {
            return modColumn;
        }

        public void setModColumn(int modColumn) {
            this.modColumn = modColumn;
        }

        public int getDiscountColumn() {
            return discountColumn;
        }

        public void setDiscountColumn(int discountColumn) {
            this.discountColumn = discountColumn;
        }

        public int getFoodGroupBtnHeight() {
            return foodGroupBtnHeight;
        }

        public void setFoodGroupBtnHeight(int foodGroupBtnHeight) {
            this.foodGroupBtnHeight = foodGroupBtnHeight;
        }

        public int getFoodBtnHeight() {
            return foodBtnHeight;
        }

        public void setFoodBtnHeight(int foodBtnHeight) {
            this.foodBtnHeight = foodBtnHeight;
        }

        public int getModBtnHeight() {
            return modBtnHeight;
        }

        public void setModBtnHeight(int modBtnHeight) {
            this.modBtnHeight = modBtnHeight;
        }

        public int getComboHeight() {
            return comboHeight;
        }

        public void setComboHeight(int comboHeight) {
            this.comboHeight = comboHeight;
        }

        public int getDiscountHeight() {
            return discountHeight;
        }

        public void setDiscountHeight(int discountHeight) {
            this.discountHeight = discountHeight;
        }

        public int getLayoutQtyHeight() {
            return LayoutQtyHeight;
        }

        public void setLayoutQtyHeight(int layoutQtyHeight) {
            LayoutQtyHeight = layoutQtyHeight;
        }

        public int getFoodGroupFontSize() {
            return foodGroupFontSize;
        }

        public void setFoodGroupFontSize(int foodGroupFontSize) {
            this.foodGroupFontSize = foodGroupFontSize;
        }

        public int getFoodFontSize() {
            return foodFontSize;
        }

        public void setFoodFontSize(int foodFontSize) {
            this.foodFontSize = foodFontSize;
        }

        public int getComboFontSize() {
            return comboFontSize;
        }

        public void setComboFontSize(int comboFontSize) {
            this.comboFontSize = comboFontSize;
        }

        public int getModFontSize() {
            return modFontSize;
        }

        public void setModFontSize(int modFontSize) {
            this.modFontSize = modFontSize;
        }

        public int getDiscountFontSize() {
            return discountFontSize;
        }

        public void setDiscountFontSize(int discountFontSize) {
            this.discountFontSize = discountFontSize;
        }

        public int getOrderNumberShowSize() {
            return OrderNumberShowSize;
        }

        public void setOrderNumberShowSize(int orderNumberShowSize) {
            OrderNumberShowSize = orderNumberShowSize;
        }

        public int getOrderNumberFontSize() {
            return OrderNumberFontSize;
        }

        public void setOrderNumberFontSize(int orderNumberFontSize) {
            OrderNumberFontSize = orderNumberFontSize;
        }

        public int getOrderNumberChildShowSize() {
            return OrderNumberChildShowSize;
        }

        public void setOrderNumberChildShowSize(int orderNumberChildShowSize) {
            OrderNumberChildShowSize = orderNumberChildShowSize;
        }

        public int getOrderNumberChildFontSize() {
            return OrderNumberChildFontSize;
        }

        public void setOrderNumberChildFontSize(int orderNumberChildFontSize) {
            OrderNumberChildFontSize = orderNumberChildFontSize;
        }

        public int getSoldoutCtrlFoodFontSize() {
            return soldoutCtrlFoodFontSize;
        }

        public void setSoldoutCtrlFoodFontSize(int soldoutCtrlFoodFontSize) {
            this.soldoutCtrlFoodFontSize = soldoutCtrlFoodFontSize;
        }
    }


    @Data
    public static final class FunctionConfiguration {
        /**
         * 賬單小數相關
         */
        private int Rounding;
        private int RoundingDecimal;
        private int ItemDecimals;

        private int DeliveryPrintCount;//外送印單打印次數
        private int DeliveryClosingPC;//外送結賬打印次數
        private int TableModePrintCount;//餐檯印單打印次數
        private int TableModeClosingPC;//餐檯模式結賬單打印次數
        private int OrderReceivingTimeout;//外送接單超時時間
        private int PrintMemberInfo;//是否打印會員信息
        private int PrintPage;//是否打印頁數
        private int PrintMergerFood;//是否合併食品
        private int PrintStatisticsAmount;//是否顯示統計打印數
        private int PrintFirstOrder;//是否打印"頭單"文字
        private int FrozenChainAutoOrder;//是否自動接單 為0true
        private int MergeSendFood;//送單是否自動合併食品
        private int AutoPrinterPaper;//送單自動打印上菜紙
        private int ToPrintQRCode;//結賬是否打印積分二維碼
        private int AutoQuitTime = 600;//餐檯模式下單頁多少秒不操作返回餐檯頁面

        public int getRounding() {
            return Rounding;
        }

        public void setRounding(int rounding) {
            Rounding = rounding;
        }

        public int getRoundingDecimal() {
            return RoundingDecimal;
        }

        public void setRoundingDecimal(int roundingDecimal) {
            RoundingDecimal = roundingDecimal;
        }

        public int getItemDecimals() {
            return ItemDecimals;
        }

        public void setItemDecimals(int itemDecimals) {
            ItemDecimals = itemDecimals;
        }

        public int getDeliveryPrintCount() {
            return DeliveryPrintCount;
        }

        public void setDeliveryPrintCount(int deliveryPrintCount) {
            DeliveryPrintCount = deliveryPrintCount;
        }

        public int getDeliveryClosingPC() {
            return DeliveryClosingPC;
        }

        public void setDeliveryClosingPC(int deliveryClosingPC) {
            DeliveryClosingPC = deliveryClosingPC;
        }

        public int getTableModePrintCount() {
            return TableModePrintCount;
        }

        public void setTableModePrintCount(int tableModePrintCount) {
            TableModePrintCount = tableModePrintCount;
        }

        public int getTableModeClosingPC() {
            return TableModeClosingPC;
        }

        public void setTableModeClosingPC(int tableModeClosingPC) {
            TableModeClosingPC = tableModeClosingPC;
        }

        public int getOrderReceivingTimeout() {
            return OrderReceivingTimeout;
        }

        public void setOrderReceivingTimeout(int orderReceivingTimeout) {
            OrderReceivingTimeout = orderReceivingTimeout;
        }

        public int getPrintMemberInfo() {
            return PrintMemberInfo;
        }

        public void setPrintMemberInfo(int printMemberInfo) {
            PrintMemberInfo = printMemberInfo;
        }

        public int getPrintPage() {
            return PrintPage;
        }

        public void setPrintPage(int printPage) {
            PrintPage = printPage;
        }

        public int getPrintMergerFood() {
            return PrintMergerFood;
        }

        public void setPrintMergerFood(int printMergerFood) {
            PrintMergerFood = printMergerFood;
        }

        public int getPrintStatisticsAmount() {
            return PrintStatisticsAmount;
        }

        public void setPrintStatisticsAmount(int printStatisticsAmount) {
            PrintStatisticsAmount = printStatisticsAmount;
        }

        public int getPrintFirstOrder() {
            return PrintFirstOrder;
        }

        public void setPrintFirstOrder(int printFirstOrder) {
            PrintFirstOrder = printFirstOrder;
        }

        public int getFrozenChainAutoOrder() {
            return FrozenChainAutoOrder;
        }

        public void setFrozenChainAutoOrder(int frozenChainAutoOrder) {
            FrozenChainAutoOrder = frozenChainAutoOrder;
        }

        public int getMergeSendFood() {
            return MergeSendFood;
        }

        public void setMergeSendFood(int mergeSendFood) {
            MergeSendFood = mergeSendFood;
        }

        public int getAutoPrinterPaper() {
            return AutoPrinterPaper;
        }

        public void setAutoPrinterPaper(int autoPrinterPaper) {
            AutoPrinterPaper = autoPrinterPaper;
        }

        public int getToPrintQRCode() {
            return ToPrintQRCode;
        }

        public void setToPrintQRCode(int toPrintQRCode) {
            ToPrintQRCode = toPrintQRCode;
        }

        public int getAutoQuitTime() {
            return AutoQuitTime;
        }

        public void setAutoQuitTime(int autoQuitTime) {
            AutoQuitTime = autoQuitTime;
        }
    }
}
