package com.gingersoft.gsa.cloud.database.bean;

import org.greenrobot.greendao.annotation.Entity;
import org.greenrobot.greendao.annotation.Generated;
import org.greenrobot.greendao.annotation.Id;
import org.greenrobot.greendao.annotation.Property;
import org.greenrobot.greendao.annotation.Transient;

import lombok.Data;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-05-08
 * 修订历史：2020-05-08
 * 描述：餐廳擴展設置表
 */
@Data
@Entity
public class ExpandInfo {

    @Property(nameInDb = "_id")
    @Id(autoincrement = true)
    private Long id;

    private int restaurantId;
    /**
     * 功能建名称
     */
    private String settingName;
    /**
     * 功能值
     */
    private Integer valueInt;
    private String valueChar;
    private String valueDatetime;
    /**
     * 功能说明
     */
    private String remark;

    /**
     * 配置的數據類型
     * 1：整形
     * 2：字符型
     * 3：布爾型
     * 4：日期類型
     */
    private int dataType;
    //是否被編輯了
    @Transient
    private boolean isUpdate = false;
    private String showName;

    public static final int data_type_int = 1;
    public static final int data_type_string = 2;
    public static final int data_type_boolean = 3;
    public static final int data_type_date = 4;
    @Generated(hash = 1155994232)
    public ExpandInfo(Long id, int restaurantId, String settingName,
            Integer valueInt, String valueChar, String valueDatetime, String remark,
            int dataType, String showName) {
        this.id = id;
        this.restaurantId = restaurantId;
        this.settingName = settingName;
        this.valueInt = valueInt;
        this.valueChar = valueChar;
        this.valueDatetime = valueDatetime;
        this.remark = remark;
        this.dataType = dataType;
        this.showName = showName;
    }
    @Generated(hash = 9429432)
    public ExpandInfo() {
    }
    public Long getId() {
        return this.id;
    }
    public void setId(Long id) {
        this.id = id;
    }
    public int getRestaurantId() {
        return this.restaurantId;
    }
    public void setRestaurantId(int restaurantId) {
        this.restaurantId = restaurantId;
    }
    public String getSettingName() {
        return this.settingName;
    }
    public void setSettingName(String settingName) {
        this.settingName = settingName;
    }
    public Integer getValueInt() {
        return this.valueInt;
    }
    public void setValueInt(Integer valueInt) {
        this.valueInt = valueInt;
    }
    public String getValueChar() {
        return this.valueChar;
    }
    public void setValueChar(String valueChar) {
        this.valueChar = valueChar;
    }
    public String getValueDatetime() {
        return this.valueDatetime;
    }
    public void setValueDatetime(String valueDatetime) {
        this.valueDatetime = valueDatetime;
    }
    public String getRemark() {
        return this.remark;
    }
    public void setRemark(String remark) {
        this.remark = remark;
    }
    public int getDataType() {
        return this.dataType;
    }
    public void setDataType(int dataType) {
        this.dataType = dataType;
    }

    public boolean isUpdate() {
        return isUpdate;
    }

    public void setUpdate(boolean update) {
        isUpdate = update;
    }

    public String getShowName() {
        return showName;
    }

    public void setShowName(String showName) {
        this.showName = showName;
    }
}
