package com.gingersoft.gsa.delivery_pick_mode.mvp.model;

import android.app.Application;

import com.gingersoft.gsa.cloud.base.common.bean.BaseResult;
import com.gingersoft.gsa.delivery_pick_mode.mvp.contract.SendOrderContract;
import com.gingersoft.gsa.delivery_pick_mode.mvp.server.SendOrderServer;
import com.google.gson.Gson;
import com.jess.arms.di.scope.ActivityScope;
import com.jess.arms.integration.IRepositoryManager;
import com.jess.arms.mvp.BaseModel;

import java.util.Map;

import javax.inject.Inject;

import io.reactivex.Observable;
import okhttp3.RequestBody;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 10/10/2020 14:40
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@ActivityScope
public class SendOrderModel extends BaseModel implements SendOrderContract.Model {
    @Inject
    Gson mGson;
    @Inject
    Application mApplication;

    @Inject
    public SendOrderModel(IRepositoryManager repositoryManager) {
        super(repositoryManager);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mGson = null;
        this.mApplication = null;
    }


    @Override
    public Observable<String> getConfirmTakeawayOrderData(Map<String, Object> map) {
        return mRepositoryManager.obtainRetrofitService(SendOrderServer.class).getConfirmTakeawayOrderData(map);
    }

    @Override
    public Observable<BaseResult> submitOrder(RequestBody requestBody) {
        return mRepositoryManager.obtainRetrofitService(SendOrderServer.class).submitOrder(requestBody);
    }

    @Override
    public Observable<MemberAddressInfoBean> getMemberAddressInfo(String phone) {
        return mRepositoryManager.obtainRetrofitService(SendOrderServer.class).getMemberAddressInfo(phone);
    }
}