package com.gingersoft.gsa.cloud.base.order.bean.mealManger;


import com.gingersoft.gsa.cloud.base.table.bean.TableBean;

import lombok.Data;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-01-09
 * 修订历史：2020-01-09
 * 描述：保存開台返回的訂單數據
 */
@Data
public class OpenTableManage {

    private String TAG = getClass().getSimpleName();
    private static OpenTableManage sDefaultOpenTableManage;

    //開台信息
    private TableBean.DataBean tableBean;
    //使用狀態
    private int useStatus;
    //開台人數
    private int peopleNumber = 0;
    //是否分檯
    private boolean isSplite = false;
    //分檯編號
    private String splitNo;

    public static OpenTableManage getDefault() {
        if (sDefaultOpenTableManage == null) {
            sDefaultOpenTableManage = new OpenTableManage();
        }
        return sDefaultOpenTableManage;
    }

    public void clear() {
        tableBean = null;
        peopleNumber = 0;
        isSplite = false;
        splitNo = "";
    }

    public String getTAG() {
        return TAG;
    }

    public void setTAG(String TAG) {
        this.TAG = TAG;
    }

    public static OpenTableManage getsDefaultOpenTableManage() {
        return sDefaultOpenTableManage;
    }

    public static void setsDefaultOpenTableManage(OpenTableManage sDefaultOpenTableManage) {
        OpenTableManage.sDefaultOpenTableManage = sDefaultOpenTableManage;
    }

    public TableBean.DataBean getTableBean() {
        return tableBean;
    }

    public void setTableBean(TableBean.DataBean tableBean) {
        this.tableBean = tableBean;
    }

    public int getUseStatus() {
        return useStatus;
    }

    public void setUseStatus(int useStatus) {
        this.useStatus = useStatus;
    }

    public int getPeopleNumber() {
        return peopleNumber;
    }

    public void setPeopleNumber(int peopleNumber) {
        this.peopleNumber = peopleNumber;
    }

    public boolean isSplite() {
        return isSplite;
    }

    public void setSplite(boolean splite) {
        isSplite = splite;
    }

    public String getSplitNo() {
        return splitNo;
    }

    public void setSplitNo(String splitNo) {
        this.splitNo = splitNo;
    }
}
