package com.gingersoft.gsa.cloud.bean.mvp.contract;

import android.content.Intent;

import com.gingersoft.gsa.cloud.base.common.bean.BaseResult;
import com.gingersoft.gsa.cloud.base.table.bean.TableBean;
import com.gingersoft.gsa.cloud.bean.mvp.model.bean.BaseOrderRespose;
import com.gingersoft.gsa.cloud.bean.mvp.model.bean.TableDetail;
import com.gingersoft.gsa.cloud.bean.mvp.ui.fragment.AllTableFragment;
import com.gingersoft.gsa.cloud.database.bean.Discount;
import com.jess.arms.base.DefaultAdapter;

import java.util.List;

import io.reactivex.Observable;
import okhttp3.RequestBody;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 01/09/2020 19:23
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
public interface OrderContentContract {

    //对于经常使用的关于UI的方法可以定义到IView中,如显示隐藏进度条,和显示文字消息
    interface View extends BaseOrderContract.View {

        void returnTableList(List<TableBean.DataBean> dataBeanList);

        AllTableFragment getCurrentTableFragment();

        void clickTableItem(TableBean.DataBean dataBean);

        void onStartRefreshTableData();

        void onPauseRefreshTableData();

        void showTransferFoodLayout();

        void hideTransferFoodLayout();

        void showChoosePeopleNumDialog(boolean isNeedCancel);

        void setTopFunctionAdapter(DefaultAdapter adapter);

        void setOrderDetailAdapter(DefaultAdapter adapter);

        void setTopFunctionRecycleLayoutManager();

        void setFoodRecycleLayoutManager(int orientation);

        void setTopFunctionRecycleSpanCount(int size);

        void setFoodRecycleSpanCount(int size);

        void printSuccess();

        void startActivityForResult(int Code, Class clazz, Intent intent);

        void sendSuccess();

        void setTransferTableName(String tableName);
    }

    //Model层定义接口,外部只需关心Model返回的数据,无需关心内部细节,即是否使用缓存
    interface Model extends BaseOrderContract.Model {

        List<Discount> queryDB_DiscountList(String discountType);

        Observable<BaseOrderRespose> createOrder(RequestBody requestBody);

        Observable<BaseOrderRespose> addFood(RequestBody requestBody);

        Observable<BaseOrderRespose> loadOrder(long  orderId);

        Observable<BaseOrderRespose> printOrder(RequestBody request);

        Observable<TableBean> getTables(int restaurantId);

        Observable<TableDetail> getTable(int tableId,String tableNumber);

        Observable<BaseOrderRespose> transferFood(RequestBody requestBody);

        Observable<BaseResult> getSplitTables(int tableId);

        Observable<BaseResult> queryCoupon(int tableId,Long memberId,long couponMemberId ,String couponNo, int restaurantId);
    }
}
