package com.gingersoft.gsa.cloud.main.mvp.ui.activity.menu;

import android.content.Intent;
import android.os.Bundle;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.gingersoft.gsa.cloud.main.R;
import com.gingersoft.gsa.cloud.main.R2;
import com.gingersoft.gsa.cloud.main.di.component.DaggerNewFoodTypeComponent;
import com.gingersoft.gsa.cloud.main.mvp.contract.NewFoodTypeContract;
import com.gingersoft.gsa.cloud.main.mvp.presenter.NewFoodTypePresenter;
import com.gingersoft.gsa.cloud.main.mvp.ui.adapter.foodmenu.FoodMenuAdapter;
import com.gingersoft.gsa.cloud.ui.recylcler.decorator.DividerItemDecoration;
import com.gingersoft.gsa.cloud.ui.widget.dialog.LoadingDialog;
import com.jess.arms.base.BaseActivity;
import com.jess.arms.di.component.AppComponent;
import com.jess.arms.utils.ArmsUtils;
import com.qmuiteam.qmui.alpha.QMUIAlphaButton;
import com.qmuiteam.qmui.widget.QMUITopBar;

import butterknife.BindView;

import static com.jess.arms.utils.Preconditions.checkNotNull;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 10/27/2020 15:25
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
public class NewFoodTypeActivity extends BaseActivity<NewFoodTypePresenter> implements NewFoodTypeContract.View {
    @BindView(R2.id.topbar_list)
    QMUITopBar topbarList;
    @BindView(R2.id.rv_content)
    RecyclerView rvContent;
    @BindView(R2.id.btn_save)
    QMUIAlphaButton btnSave;
    @Override
    public void setupActivityComponent(@NonNull AppComponent appComponent) {
        DaggerNewFoodTypeComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .view(this)
                .build()
                .inject(this);
    }

    @Override
    public int initView(@Nullable Bundle savedInstanceState) {
        return R.layout.activity_new_food_type;
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {

        rvContent.addItemDecoration(new DividerItemDecoration(mContext, LinearLayoutManager.VERTICAL));
        rvContent.setLayoutManager(new LinearLayoutManager(mContext));
        rvContent.setAdapter(FoodMenuAdapter.getFoodMenuAdapter(mContext, FoodMenuAdapter.NEW_FOOD_TYPE));
    }

    @Override
    public void initIntent() {

    }

    @Override
    public void initTopBar() {
        topbarList.setTitle("新增餐種");
        topbarList.addLeftImageButton(R.drawable.icon_return, R.id.iv_left_back).setOnClickListener(v -> finish());
    }

    @Override
    public void initLanguage() {

    }

    @Override
    public void initLayoutParams() {

    }

    @Override
    public void initLayoutVisible() {

    }

    @Override
    public void showLoading(String message) {
        if (message != null) {
            LoadingDialog.showDialogForLoading(this, message, true);
        } else {
            LoadingDialog.showDialogForLoading(this);
        }
    }

    @Override
    public void hideLoading() {
        LoadingDialog.cancelDialogForLoading();
    }

    @Override
    public void showMessage(@NonNull String message) {
        ArmsUtils.makeText(this, message);
    }

    @Override
    public void launchActivity(@NonNull Intent intent) {
        checkNotNull(intent);
        ArmsUtils.startActivity(intent);
    }

    @Override
    public void killMyself() {
        finish();
    }
}
