package com.gingersoft.gsa.cloud.main.mvp.ui.adapter.foodmenu;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.main.R;
import com.gingersoft.gsa.cloud.main.mvp.model.bean.FoodGroupBean;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;

/**
 * @author 宇航.
 * User: admin
 * Date: 2020/10/29
 * Time: 16:32
 * Use:
 */
public class FoodGroupEditAdapter extends BaseQuickAdapter<FoodGroupBean, BaseViewHolder> {

    private boolean isShowEdit = false;

    public FoodGroupEditAdapter(@Nullable List<FoodGroupBean> data) {
        super(R.layout.item_food_group_edit, data);
        addChildClickViewIds(R.id.iv_food_group_delete);
    }

    @Override
    protected void convert(@NotNull BaseViewHolder baseViewHolder, FoodGroupBean foodGroupBean) {
        baseViewHolder.setText(R.id.tv_food_group_name, foodGroupBean.getFoodGroupName());
        baseViewHolder.setGone(R.id.iv_food_group_edit, !isShowEdit);
        baseViewHolder.setGone(R.id.iv_food_group_delete, !isShowEdit);
    }

    public void setShowEdit() {
        isShowEdit = !isShowEdit;
        super.notifyDataSetChanged();
    }
}
