package com.gingersoft.gsa.cloud.main.mvp.ui.adapter.foodmenu;

import android.content.Context;
import android.graphics.Color;
import android.widget.TextView;

import androidx.core.content.ContextCompat;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.main.R;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;

/**
 * @author 宇航.
 * User: admin
 * Date: 2020/10/30
 * Time: 12:19
 * Use:
 */
public class FoodMenuMangerLeftAdapter extends BaseQuickAdapter<String, BaseViewHolder> {

    private int selectIndex = 0;
    private Context context;

    private int whiteColor;
    private int blueColor;
    private int textNormalColor;
    public FoodMenuMangerLeftAdapter(Context context, @Nullable List<String> data) {
        super(R.layout.item_food_menu_manger_left, data);
        this.context = context;
        whiteColor = ContextCompat.getColor(context, R.color.white);
        blueColor = ContextCompat.getColor(context, R.color.theme_color);
        textNormalColor = ContextCompat.getColor(context, R.color.color_3c);
    }

    @Override
    protected void convert(@NotNull BaseViewHolder baseViewHolder, String s) {
        TextView mTvCategoryName = baseViewHolder.getView(R.id.tv_food_menu_manger_category_name);
        mTvCategoryName.setText(s);
        if (selectIndex == baseViewHolder.getAdapterPosition()) {
            mTvCategoryName.setBackgroundColor(whiteColor);
            mTvCategoryName.setTextColor(blueColor);
        } else {
            mTvCategoryName.setBackgroundColor(Color.TRANSPARENT);
            mTvCategoryName.setTextColor(textNormalColor);
        }
    }

    public void setSelectIndex(int selectIndex) {
        this.selectIndex = selectIndex;
        notifyDataSetChanged();
    }
}
