package com.gingersoft.gsa.cloud.main.mvp.ui.adapter.foodmenu;

import android.widget.SectionIndexer;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.main.R;

import org.jetbrains.annotations.NotNull;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * @author 宇航.
 * User: admin
 * Date: 2020/10/30
 * Time: 11:38
 * Use:
 */
public class FoodMenuMangerRightAdapter extends BaseQuickAdapter<String, BaseViewHolder> implements SectionIndexer {

    private String[] foods;
    private List<String> category;


    public FoodMenuMangerRightAdapter(List<String> category, String[] foods) {
        super(R.layout.item_food_menu_right_food_info, new ArrayList<>(Arrays.asList(foods)));
        this.foods = foods;
        this.category = category;
    }

    @Override
    public Object[] getSections() {
        return category.toArray();
    }

    @Override
    public int getPositionForSection(int sectionIndex) {
        for (int i = 0; i < foods.length; i++) {
            if (foods[i].contains(category.get(sectionIndex))) {
                return i;
            }
        }
        return 0;
    }

    @Override
    public int getSectionForPosition(int position) {
        for (int i = 0; i < category.size(); i++) {
            if (foods[position].contains(category.get(i))) {
                return i;
            }
        }
        return 0;
    }

    @Override
    protected void convert(@NotNull BaseViewHolder baseViewHolder, String s) {
        baseViewHolder.setText(R.id.item_food_menu_food_name, s);
    }
}
