package com.gingersoft.gsa.cloud.main.mvp.ui.adapter.foodmenu;

import android.content.Context;
import android.content.Intent;
import android.view.View;
import android.widget.TextView;

import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.base.utils.other.TextUtil;
import com.gingersoft.gsa.cloud.main.R;
import com.gingersoft.gsa.cloud.main.mvp.model.bean.FoodMenuEditBean;

import org.jetbrains.annotations.NotNull;

/**
 * @author admin
 */
public class SelectItemProvider extends FoodMenuItemProvider {
    private Context context;

    public SelectItemProvider(Context context) {
        this.context = context;
    }

    @Override
    public int getItemViewType() {
        return FoodMenuEditBean.EDIT_FOOD_ITEM_SELECT;
    }

    @Override
    public int getLayoutId() {
        return R.layout.item_jump_select;
    }

    @Override
    public void convert(@NotNull BaseViewHolder baseViewHolder, FoodMenuEditBean foodMenuEditBean) {
        super.convert(baseViewHolder, foodMenuEditBean);
        TextView textView = baseViewHolder.getView(R.id.tv_food_menu_value);
        if (TextUtil.isNotEmptyOrNullOrUndefined(foodMenuEditBean.getShowValue())) {
            textView.setText(foodMenuEditBean.getShowValue());
        } else if (TextUtil.isNotEmptyOrNullOrUndefined(foodMenuEditBean.getHintText())) {
            textView.setText(foodMenuEditBean.getHintText());
        }
    }

    @Override
    public void onClick(@NotNull BaseViewHolder helper, @NotNull View view, FoodMenuEditBean data, int position) {
        super.onClick(helper, view, data, position);
        if (data.getCls() != null) {
            context.startActivity(new Intent(context, data.getCls()));
        }
    }
}
