package com.gingersoft.gsa.cloud.table.mvp.ui.adapter;

import android.content.Context;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

import com.gingersoft.gsa.cloud.database.bean.Function;
import com.gingersoft.gsa.cloud.table.R;
import com.gingersoft.gsa.cloud.table.R2;
import com.jess.arms.base.BaseHolder;
import com.jess.arms.base.DefaultAdapter;

import java.util.List;

import butterknife.BindView;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2018/8/31
 * 修订历史：2018/8/31
 * 描述：餐檯底部功能列表
 */

public class BottomFunctionAdapter extends DefaultAdapter<Function> {

    private Context mContext;

    public static final int VIEW_TYPE_NOMAL = 1;
    public static final int VIEW_TYPE_SKYORDER = 2;

    public BottomFunctionAdapter(Context context, List<Function> infos) {
        super(infos);
        this.mContext = context;
    }

    @Override
    public int getItemCount() {
        return mInfos.size();
    }

    @Override
    public BaseHolder<Function> getHolder(View v, int viewType) {
        if (viewType == VIEW_TYPE_SKYORDER) {
            return new SkyorderFunctionItemHolder(v);
        } else {
            return new BottomFunctionItemHolder(v);
        }
    }

    @Override
    public int getLayoutId(int viewType) {
        if (viewType == VIEW_TYPE_SKYORDER) {
            return R.layout.table_item_skyorder;
        } else {
            return R.layout.table_item_table_bottom;
        }
    }

    @Override
    public int getItemViewType(int position) {
        Function function = getItem(position);
        if (function.isRaisedBottom()) {
            return VIEW_TYPE_SKYORDER;
        }
        return VIEW_TYPE_NOMAL;
    }

    class BottomFunctionItemHolder extends BaseHolder<Function> {

        @BindView(R2.id.tv_name)
        TextView tv_name;
        @BindView(R2.id.iv_icon)
        ImageView iv_icon;

        public BottomFunctionItemHolder(View itemView) {
            super(itemView);
        }

        @Override
        public void setData(Function item, int position) {

            initItemData(item);
        }

        private void initItemData(Function item) {

            tv_name.setText(item.getResName());
            iv_icon.setImageResource(item.getIcRes());
        }
    }

    class SkyorderFunctionItemHolder extends BaseHolder<Function> {

        @BindView(R2.id.tv_name)
        TextView tv_name;
        @BindView(R2.id.iv_lock)
        ImageView iv_lock;

        public SkyorderFunctionItemHolder(View itemView) {
            super(itemView);
        }

        @Override
        public void setData(Function item, int position) {

            tv_name.setText(item.getResName());
        }

    }
}
