package com.gingersoft.gsa.cloud.config.expandInfo;

import lombok.Getter;
import lombok.Setter;
import com.gingersoft.gsa.cloud.config.expandInfo.ExpandInfoSetting;
/**
 * @author : bin
 * @create date: 2020-10-20
 * @update date: 2020-10-20
 * @description:頁面樣式擴展配置類
 */
@Getter
@Setter
public class UIStyleExtendedConfiguration {

    /**
     * 食品組、食品、細項、折扣行列寬高
     */
    private ExpandInfoSetting foodGroupRow = ExpandInfoSetting.builder()
            .valueInt(2)
            .remark("食品組行數")
            .build();
    private ExpandInfoSetting foodGroupColumn = ExpandInfoSetting.builder()
            .valueInt(5)
            .remark("食品組列數")
            .build();
    private ExpandInfoSetting foodColumn = ExpandInfoSetting.builder()
            .valueInt(4)
            .remark("食品列數")
            .build();
    private ExpandInfoSetting comboColumn = ExpandInfoSetting.builder()
            .valueInt(4)
            .remark("套餐列數")
            .build();
    private ExpandInfoSetting modColumn = ExpandInfoSetting.builder()
            .valueInt(4)
            .remark("細項列數")
            .build();
    private ExpandInfoSetting discountColumn = ExpandInfoSetting.builder()
            .valueInt(4)
            .remark("餐牌折扣列數")
            .build();

    /**
     * 食品組、食品、細項、折扣Item高度
     */
    private ExpandInfoSetting foodGroupBtnHeight = ExpandInfoSetting.builder()
            .valueInt(150)
            .remark("食品組高度")
            .build();
    private ExpandInfoSetting foodBtnHeight = ExpandInfoSetting.builder()
            .valueInt(120)
            .remark("食品高度")
            .build();
    private ExpandInfoSetting modBtnHeight = ExpandInfoSetting.builder()
            .valueInt(80)
            .remark("細項高度")
            .build();
    private ExpandInfoSetting comboHeight = ExpandInfoSetting.builder()
            .valueInt(90)
            .remark("套餐高度")
            .build();
    private ExpandInfoSetting discountHeight = ExpandInfoSetting.builder()
            .valueInt(90)
            .remark("餐牌折扣Item高度")
            .build();
    private ExpandInfoSetting LayoutQtyHeight = ExpandInfoSetting.builder()
            .valueInt(40)
            .remark("選擇數量紅點高度")
            .build();
    private ExpandInfoSetting soldoutFoodFlagHeight = ExpandInfoSetting.builder()
            .valueInt(20)
            .remark("食品沽清標誌高度")
            .build();
    private ExpandInfoSetting soldoutModFlagHeight = ExpandInfoSetting.builder()
            .valueInt(15)
            .remark("細項沽清標誌高度")
            .build();
    /**
     * 食品組、食品、細項、折扣字體大小
     */
    private ExpandInfoSetting billListFontSize = ExpandInfoSetting.builder()
            .valueInt(18)
            .remark("餐牌選中食品字體大小")
            .build();
    private ExpandInfoSetting foodGroupFontSize = ExpandInfoSetting.builder()
            .valueInt(14)
            .remark("食品組字體大小")
            .build();
    private ExpandInfoSetting foodFontSize = ExpandInfoSetting.builder()
            .valueInt(14)
            .remark("食品字體大小")
            .build();
    private ExpandInfoSetting comboFontSize = ExpandInfoSetting.builder()
            .valueInt(12)
            .remark("套餐字體大小")
            .build();
    private ExpandInfoSetting modFontSize = ExpandInfoSetting.builder()
            .valueInt(12)
            .remark("細項字體大小")
            .build();
    private ExpandInfoSetting discountFontSize = ExpandInfoSetting.builder()
            .valueInt(16)
            .remark("折扣字體大小")
            .build();
    private ExpandInfoSetting soldoutFoodFlagFontSize = ExpandInfoSetting.builder()
            .valueInt(10)
            .remark("食品沽清標誌字體大小")
            .build();
    private ExpandInfoSetting soldoutModFlagFontSize = ExpandInfoSetting.builder()
            .valueInt(7)
            .remark("細項沽清標誌字體大小")
            .build();
    private ExpandInfoSetting soldoutCtrlFoodFontSize = ExpandInfoSetting.builder()
            .valueInt(14)
            .remark("估清控制item字體大小")
            .build();

    /**
     * skyorder Qrcode檯标识配置
     */
    private ExpandInfoSetting SkyQRCodeTableFlagTextSize = ExpandInfoSetting.builder()
            .valueInt(16)
            .remark("skyorder QRCode餐檯標記字體大小")
            .build();
    private ExpandInfoSetting SkyQRCodeTableFlagTextColor = ExpandInfoSetting.builder()
            .valueChar("#FFFFFF")
            .remark("skyorder QRCode餐檯標記字體顏色")
            .build();
    private ExpandInfoSetting SkyQRCodeTableFlagBackgroupColor = ExpandInfoSetting.builder()
            .valueChar("#f57c00")
            .remark("skyorder QRCode餐檯標記背景顏色")
            .build();
    private ExpandInfoSetting SkyQRCodeTableFlagWith = ExpandInfoSetting.builder()
            .valueInt(25)
            .remark("skyorder QRCode餐檯標記寬度")
            .build();
    private ExpandInfoSetting SkyQRCodeTableFlagHeight = ExpandInfoSetting.builder()
            .valueInt(25)
            .remark("skyorder QRCode餐檯標記高度")
            .build();


    public <T> T getFoodGroupRowValue() {
        return foodGroupRow.getValue();
    }

    public <T> T  getFoodGroupColumnValue() {
        return foodGroupColumn.getValue();
    }

    public <T> T  getFoodColumnValue() {
        return foodColumn.getValue();
    }

    public <T> T  getComboColumnValue() {
        return comboColumn.getValue();
    }

    public <T> T  getModColumnValue() {
        return modColumn.getValue();
    }

    public <T> T  getDiscountColumnValue() {
        return discountColumn.getValue();
    }

    public <T> T  getFoodGroupBtnHeightValue() {
        return foodGroupBtnHeight.getValue();
    }

    public <T> T  getFoodBtnHeightValue() {
        return foodBtnHeight.getValue();
    }

    public <T> T getModBtnHeightValue() {
        return modBtnHeight.getValue();
    }

    public <T> T getComboHeightValue() {
        return comboHeight.getValue();
    }

    public <T> T getDiscountHeightValue() {
        return discountHeight.getValue();
    }

    public <T> T getLayoutQtyHeightValue() {
        return LayoutQtyHeight.getValue();
    }

    public <T> T getSoldoutFoodFlagHeightValue() {
        return soldoutFoodFlagHeight.getValue();
    }

    public <T> T  getSoldoutModFlagHeightValue() {
        return soldoutModFlagHeight.getValue();
    }

    public <T> T  getFoodGroupFontSizeValue() {
        return foodGroupFontSize.getValue();
    }

    public <T> T  getBillListFontSizeValue() {
        return billListFontSize.getValue();
    }
    public <T> T  getFoodFontSizeValue() {
        return foodFontSize.getValue();
    }

    public <T> T  getComboFontSizeValue() {
        return comboFontSize.getValue();
    }

    public <T> T  getModFontSizeValue() {
        return modFontSize.getValue();
    }

    public <T> T  getDiscountFontSizeValue() {
        return discountFontSize.getValue();
    }

    public <T> T  getSoldoutFoodFlagFontSizeValue() {
        return soldoutFoodFlagFontSize.getValue();
    }

    public <T> T  getSoldoutModFlagFontSizeValue() {
        return soldoutModFlagFontSize.getValue();
    }

    public <T> T  getSoldoutCtrlFoodFontSizeValue() {
        return soldoutCtrlFoodFontSize.getValue();
    }

    public  <T> T  getSkyQRCodeTableFlagTextSizeValue() {
        return SkyQRCodeTableFlagTextSize.getValue();
    }

    public  <T> T  getSkyQRCodeTableFlagTextColorValue() {
        return SkyQRCodeTableFlagTextColor.getValue();
    }

    public  <T> T  getSkyQRCodeTableFlagBackgroupColorValue() {
        return SkyQRCodeTableFlagBackgroupColor.getValue();
    }

    public  <T> T  getSkyQRCodeTableFlagWithValue() {
        return SkyQRCodeTableFlagWith.getValue();
    }

    public  <T> T  getSkyQRCodeTableFlagHeightValue() {
        return SkyQRCodeTableFlagHeight.getValue();
    }
}
