package com.joe.print.mvp.print;

import android.content.Context;
import android.graphics.Bitmap;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

import com.gingersoft.gsa.cloud.base.utils.view.QRCodeUtil;
import com.gingersoft.gsa.cloud.database.bean.PrinterDeviceBean;
import com.gingersoft.gsa.cloud.print.bean.PrintQRCodeContent;
import com.joe.print.R;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * skyorder qrcode打印
 */
public class PrintQRCode extends PrinterRoot {

    private PrintQRCodeContent mQRCodeBean;

    public PrintQRCode(PrintQRCodeContent qrCodeBean) {
        this.mQRCodeBean = qrCodeBean;
    }

    @Override
    public Map<String, List<Bitmap>> getPrintBitmap(Context mContext, PrinterDeviceBean printerDeviceBean) {
        Map<String, List<Bitmap>> bitmapMaps = new HashMap<>();
        List<Bitmap> bitmaps = new ArrayList<>();
        bitmaps.add(getBitmap(mContext, printerDeviceBean));
        bitmapMaps.put("", bitmaps);
        return bitmapMaps;
    }

    @Override
    public String getPrintData(Context mContext, PrinterDeviceBean deviceBean) {
        return null;
    }

    @Override
    public int getPrintCount(Context context) {
        return 1;
    }


    private Bitmap getBitmap(Context mContext, PrinterDeviceBean printerDeviceBean) {
        return viewToZoomBitmap(mContext, getPrintView(mContext), printerDeviceBean);
    }

    public View getPrintView(Context context) {
        View view = View.inflate(context, R.layout.print_skyorder_qrcode, null);
        TextView printTableName = view.findViewById(R.id.print_table_name);
        TextView printTopInfo = view.findViewById(R.id.print_top_info);
        ImageView printQrcode = view.findViewById(R.id.print_qrcode);
        TextView printTime = view.findViewById(R.id.print_time);
        TextView printPeopleNum = view.findViewById(R.id.print_people_num);
        TextView printMealEndTime = view.findViewById(R.id.print_meal_end_time);
        TextView printBottonInfo = view.findViewById(R.id.print_botton_info);

        printTableName.setText(mQRCodeBean.getPrintTableName());
        printTopInfo.setText(mQRCodeBean.getPrintTopInfo());
        printTime.setText(mQRCodeBean.getPrintTime());
        printPeopleNum.setText(mQRCodeBean.getPrintPeopleNum());
        printMealEndTime.setText(mQRCodeBean.getPrintMealEndTime());
        printBottonInfo.setText(mQRCodeBean.getBottonInfo());

        Bitmap QRImage = QRCodeUtil.createQRImage(mQRCodeBean.getPrintQrcode(), 180, 180);
        if (QRImage != null) {
            printQrcode.setImageBitmap(QRImage);
        }
        return view;
    }
}
