package com.gingersoft.gsa.cloud.table.mvp.ui.adapter.meal;

import android.content.Context;
import android.graphics.Color;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.gingersoft.gsa.cloud.base.application.GsaCloudApplication;
import com.gingersoft.gsa.cloud.database.bean.Discount;
import com.gingersoft.gsa.cloud.table.R;
import com.gingersoft.gsa.cloud.table.R2;
import com.gingersoft.gsa.cloud.ui.view.BeveLabelView;
import com.jess.arms.base.BaseHolder;
import com.jess.arms.base.DefaultAdapter;
import com.jess.arms.utils.ArmsUtils;
import java.util.List;
import butterknife.BindView;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2018/6/27
 * 修订历史：2018/6/27
 * 描述：
 */

public class DiscountAdapter extends DefaultAdapter<Discount> {

    private Context mContext;

    private int fontSize;
    private int colHeight;

    public DiscountAdapter(Context context, List<Discount> infos) {
        super(infos);
        this.mContext = context;
        fontSize = GsaCloudApplication.uiStyleConfiguration.getDiscountFontSizeValue();
        colHeight = GsaCloudApplication.uiStyleConfiguration.getDiscountHeightValue();
    }

    @Override
    public int getItemCount() {
        return mInfos.size();
    }

    @Override
    public BaseHolder<Discount> getHolder(View v, int viewType) {
        return new DiscountItemHolder(v);
    }

    @Override
    public int getLayoutId(int viewType) {
        return R.layout.meal_item_discount;
    }

    class DiscountItemHolder extends BaseHolder<Discount> {

        @BindView(R2.id.tv_name)
        TextView tv_name;
        @BindView(R2.id.blv_soldout)
        BeveLabelView blv_soldout;

        public DiscountItemHolder(View itemView) {
            super(itemView);
        }

        @Override
        public void setData(Discount datasBean, int position) {

            initLayoutParams();
            initName(datasBean);
            initSoldoutStatus(datasBean);
            setColor(datasBean);
        }

        private void initName(Discount datasBean) {
            String desc = datasBean.getRemark();
            tv_name.setText(desc);
            tv_name.setTextSize(fontSize);
        }

        private void initSoldoutStatus(Discount datasBean) {
            if (datasBean.isPause()) {
                blv_soldout.setLableText("暫停");
                blv_soldout.setVisibility(View.VISIBLE);
            } else {
                blv_soldout.setVisibility(View.GONE);
            }
        }

        private void setColor(Discount datasBean) {
            String colorRes = datasBean.getColor();
            if (!TextUtils.isEmpty(colorRes) && colorRes.startsWith("#")) {
                tv_name.setBackgroundColor(Color.parseColor(colorRes));
            } else {
                int color = ArmsUtils.getColor(mContext, R.color.light_blue_900);
                tv_name.setBackgroundColor(color);
            }
            int fontColor = ArmsUtils.getColor(mContext, R.color.theme_white_color);
            tv_name.setTextColor(fontColor);
        }

        private void initLayoutParams() {
            ViewGroup.LayoutParams layoutParams = tv_name.getLayoutParams();
            layoutParams.height = colHeight;
            tv_name.setLayoutParams(layoutParams);
        }
    }

}
