package com.gingersoft.gsa.cloud.manager.mvp.ui.adapter;

import android.content.Context;
import android.graphics.Color;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;

import com.gingersoft.gsa.cloud.common.core.table.TableManagerItem;
import com.gingersoft.gsa.cloud.common.utils.StringUtils;
import com.gingersoft.gsa.cloud.manager.R;
import com.gingersoft.gsa.cloud.manager.R2;
import com.gingersoft.gsa.cloud.ui.bean.view.SectionHeader;
import com.gingersoft.gsa.cloud.ui.view.TriangleLabelView;
import com.gingersoft.gsa.cloud.ui.view.qm.QDLoadingItemView;
import com.gingersoft.gsa.cloud.ui.view.section.QDSectionHeaderView;
import com.jess.arms.utils.DeviceUtils;
import com.qmuiteam.qmui.layout.QMUIRelativeLayout;
import com.qmuiteam.qmui.util.QMUIDisplayHelper;
import com.qmuiteam.qmui.widget.section.QMUIDefaultStickySectionAdapter;
import com.qmuiteam.qmui.widget.section.QMUISection;
import com.qmuiteam.qmui.widget.section.QMUIStickySectionAdapter;

import java.util.HashMap;

import butterknife.BindView;
import butterknife.ButterKnife;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-02-09
 * 修订历史：2020-02-09
 * 描述：
 */
public class TableManageSectiontAdapter extends QMUIDefaultStickySectionAdapter<SectionHeader, TableManagerItem> {

    private Context context;
    private boolean isRadioEdit = false;

    //Item行数（行数根据数据自动计算）
    private int ItemRowCount = 6;
    //Item高度
    private int ItemColHeight;

    private int mRadius;
    private float mShadowAlpha = 0.25f;
    private int mShadowElevationDp = 14;

    private HashMap<Long,Boolean> mSelectedStatus = new HashMap<>();

    public void initItemDispalyHeight() {
        float screenHeight = DeviceUtils.getScreenHeight(context) - 75 - 75;
        ItemColHeight = (int) Math.ceil((double) screenHeight / (double) (ItemRowCount));
        ItemColHeight = ItemColHeight - 3;
    }

    @NonNull
    @Override
    protected QMUIStickySectionAdapter.ViewHolder onCreateSectionHeaderViewHolder(@NonNull ViewGroup viewGroup) {
        this.context = viewGroup.getContext();
        this.mRadius = QMUIDisplayHelper.dp2px(context, 5);
        initItemDispalyHeight();

        return new QMUIStickySectionAdapter.ViewHolder(new QDSectionHeaderView(viewGroup.getContext()));
    }

    @NonNull
    @Override
    protected ViewHolder onCreateSectionItemViewHolder(@NonNull ViewGroup viewGroup) {
        this.context = viewGroup.getContext();
        return new ViewHolder(View.inflate(viewGroup.getContext(), R.layout.manager_item_manage_table, null));
    }

    @NonNull
    @Override
    protected QMUIStickySectionAdapter.ViewHolder onCreateSectionLoadingViewHolder(@NonNull ViewGroup viewGroup) {
        return new QMUIStickySectionAdapter.ViewHolder(new QDLoadingItemView(viewGroup.getContext()));
    }

    @Override
    protected void onBindSectionHeader(QMUIStickySectionAdapter.ViewHolder holder, int position, QMUISection<SectionHeader, TableManagerItem> section) {
        super.onBindSectionHeader(holder, position, section);
        QDSectionHeaderView itemView = (QDSectionHeaderView) holder.itemView;
        itemView.render(section.getHeader(), section.isFold());
        for (int i = 0; i < section.getItemList().size(); i++) {
            TableManagerItem tableItem = section.getItemList().get(i);
            if(!mSelectedStatus.containsKey(tableItem.getId())) {
                mSelectedStatus.put(tableItem.getId(),false);
            }
        }
//        itemView.setBackgroundColor(ContextCompat.getColor(context,R.color.theme_background_color));
        itemView.getArrowView().setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                int pos = holder.isForStickyHeader ? position : holder.getAdapterPosition();
                toggleFold(pos, false);
            }
        });
    }

    @Override
    protected void onBindSectionItem(QMUIStickySectionAdapter.ViewHolder holder, int position, QMUISection<SectionHeader, TableManagerItem> section, int itemIndex) {
        super.onBindSectionItem(holder, position, section, itemIndex);
        ViewHolder viewHolder = (ViewHolder) holder;

        TableManagerItem tableItem = section.getItemAt(itemIndex);

        if (tableItem.getLayoutType() == 1) {

            viewHolder.fl_add_table.setVisibility(View.VISIBLE);
            viewHolder.rl_table.setVisibility(View.GONE);
            viewHolder.fl_table_type.setVisibility(View.GONE);

            initAddItemDispalyMetrics(viewHolder);

            viewHolder.ll_container.setBackgroundColor(Color.parseColor("#FFFFFFFF"));
            setBackGroundWork(viewHolder, Color.parseColor("#FFFFFFFF"), R.color.black, R.color.theme_black);

//            viewHolder.cb_checked.setChecked(false);
            viewHolder.cb_checked.setOnCheckedChangeListener(null);
            viewHolder.cb_checked.setVisibility(View.GONE);
        } else {

//            viewHolder.cb_checked.setChecked(false);
            viewHolder.rl_table.setVisibility(View.VISIBLE);
            viewHolder.fl_add_table.setVisibility(View.GONE);

            initTableItemData(viewHolder, tableItem);
            initTableItemDispalyMetrics(viewHolder);
            initTableBackground(viewHolder, tableItem);

            if (tableItem.getServiceCharge() > 0) {
                viewHolder.tv_service_fee.setText(tableItem.getServiceCharge() + "%");
                viewHolder.tv_service_fee.setVisibility(View.VISIBLE);
            } else {
                viewHolder.tv_service_fee.setVisibility(View.GONE);
            }
            if (isRadioEdit && tableItem.getUseStatus() == 0 && tableItem.getStatus() == 0) {
                viewHolder.cb_checked.setVisibility(View.VISIBLE);
                viewHolder.cb_checked.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
                    @Override
                    public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                        buttonView.setChecked(isChecked);
                        tableItem.setChecked(isChecked);
                    }
                });
            } else {
                viewHolder.cb_checked.setOnCheckedChangeListener(null);
                viewHolder.cb_checked.setVisibility(View.GONE);
            }
        }
        viewHolder.cb_checked.setChecked(tableItem.isChecked());
        viewHolder.ll_container.setRadiusAndShadow(mRadius, QMUIDisplayHelper.dp2px(context, mShadowElevationDp), mShadowAlpha);
    }

    private void initTableItemData(ViewHolder viewHolder, TableManagerItem item) {

        viewHolder.tv_table.setText(item.getTableName());

        if (StringUtils.getChineseValueLength(item.getTableName()) > 5) {
            viewHolder.tv_table.setTextSize(18);
        } else {
            viewHolder.tv_table.setTextSize(22);
        }

        if (item.getStatus() != 0) {
            viewHolder.tv_people.setVisibility(View.VISIBLE);
            if (item.getMinSeatCount() != 0 || item.getMaxSeatCount() != 0) {
                viewHolder.tv_people.setText(item.getMinSeatCount() + "-" + item.getMaxSeatCount() + "人");
            } else {
                viewHolder.tv_people.setText("");
            }
            viewHolder.tv_table.setMaxLines(1);
        } else {
            //未開檯空間足夠可換行顯示
            viewHolder.tv_table.setMaxLines(2);
            viewHolder.tv_people.setVisibility(View.GONE);
        }

        if (item.getStatus() != 0) {
            switch (item.getType()) {
                case TableManagerItem.TABLE_TYPE_CANTEEN:
                    viewHolder.tv_type_labe.setText("堂");
                    viewHolder.tv_type_labe.setTextColor(Color.parseColor("#249B65"));
                    break;
                case TableManagerItem.TABLE_TYPE_TAKEAWAY:
                    viewHolder.tv_type_labe.setText("外");
                    viewHolder.tv_type_labe.setTextColor(Color.parseColor("#FF720A"));
                    break;
                case TableManagerItem.TABLE_TYPE_SELF_FETCHING:
                    viewHolder.tv_type_labe.setText("自");
                    viewHolder.tv_type_labe.setTextColor(Color.parseColor("#00479D"));
                    break;
            }
            viewHolder.fl_table_type.setVisibility(View.VISIBLE);
        } else {
            viewHolder.fl_table_type.setVisibility(View.GONE);
        }
    }

    private void initTableBackground(ViewHolder viewHolder, TableManagerItem item) {
//            if (item.getSplitStatus() != 0) {
//                setBackGroundWork(item, "888", R.drawable.tablebutton_splite, R.drawable.tablebutton_splite_new, R.color.black);
//            } else {

        viewHolder.ll_container.setBackgroundColor(Color.parseColor("#FFFFFFFF"));

        if (item.getUseStatus() == 1) {
            setBackGroundWork(viewHolder, Color.parseColor("#FFD14141"), R.color.theme_white_color, R.color.theme_black);
        } else {
            switch (item.getStatus()) {
                case 0:
                    setBackGroundWork(viewHolder, Color.parseColor("#FFFFFFFF"), R.color.black, R.color.theme_black);
                    break;
                case 1:
//                        setBackGroundWork(item, "2", R.drawable.table_shape_table_send, R.drawable.tablebutton_glassgreen_new, R.color.theme_white_color);                        break;
                case 2:
                    setBackGroundWork(viewHolder, Color.parseColor("#FF249B65"), R.color.theme_white_color, R.color.theme_white_color);
                    break;
                case 3:
                    setBackGroundWork(viewHolder, Color.parseColor("#FFE5AC00"), R.color.theme_white_color, R.color.theme_white_color);
                    break;
                case 4:
                    setBackGroundWork(viewHolder, ContextCompat.getColor(context, R.color.app_color_blue_2), R.color.theme_white_color, R.color.theme_white_color);
                    break;
                case 5:
                case 6:
                    setBackGroundWork(viewHolder, ContextCompat.getColor(context, R.color.Violet), R.color.theme_white_color, R.color.theme_white_color);
                    break;
            }
        }
    }

    private void initTableItemDispalyMetrics(ViewHolder viewHolder) {
        if (viewHolder.tv_table.getGravity() != Gravity.CENTER) {
            viewHolder.rl_table.setGravity(Gravity.CENTER);
            RelativeLayout.LayoutParams lp = (RelativeLayout.LayoutParams) viewHolder.rl_table.getLayoutParams();
            lp.height = ItemColHeight;
            viewHolder.rl_table.setLayoutParams(lp);
        }
        viewHolder.rl_table.setMinimumHeight(ItemColHeight);

        RelativeLayout.LayoutParams relativeLayout = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.MATCH_PARENT, RelativeLayout.LayoutParams.MATCH_PARENT);
        relativeLayout.height = ItemColHeight;
        viewHolder.rl_table.setLayoutParams(relativeLayout);
    }

    private void setBackGroundWork(ViewHolder viewHolder, int defaultMainback, int defaultFontColor, int serviceFeeFontColor) {
        if (defaultMainback != -1) {
            viewHolder.ll_container.setBackgroundColor(defaultMainback);
        }
        viewHolder.tv_table.setTextColor(context.getResources().getColor(defaultFontColor));
        viewHolder.tv_service_fee.setTextColor(context.getResources().getColor(serviceFeeFontColor));
    }

    private void initAddItemDispalyMetrics(ViewHolder viewHolder) {
        RelativeLayout.LayoutParams lp = (RelativeLayout.LayoutParams) viewHolder.fl_add_table.getLayoutParams();
        viewHolder.fl_add_table.setLayoutParams(lp);

        viewHolder.fl_add_table.setMinimumHeight(ItemColHeight);

        RelativeLayout.LayoutParams relativeLayout = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.MATCH_PARENT, RelativeLayout.LayoutParams.MATCH_PARENT);
        relativeLayout.height = ItemColHeight;
        viewHolder.fl_add_table.setLayoutParams(relativeLayout);
    }

    public void setRadioEdit(boolean radioEdit) {
        isRadioEdit = radioEdit;
    }

    public class ViewHolder extends QMUIStickySectionAdapter.ViewHolder {

        @BindView(R2.id.ll_container)
        QMUIRelativeLayout ll_container;
        @BindView(R2.id.rl_table)
        RelativeLayout rl_table;
        @BindView(R2.id.tv_table)
        TextView tv_table;
        @BindView(R2.id.tv_people)
        TextView tv_people;
        //        @BindView(R2.id.btn_showMain)
//        Button btn_showMain;
//        @BindView(R2.id.iv_vip)
//        ImageView iv_vip;
//        @BindView(R2.id.tv_scan_flag)
//        TextView tv_scan_flag;
        @BindView(R2.id.tv_service_fee)
        TextView tv_service_fee;
        @BindView(R2.id.cb_checked)
        CheckBox cb_checked;

        @BindView(R2.id.fl_add_table)
        FrameLayout fl_add_table;
        @BindView(R2.id.fl_table_type)
        FrameLayout fl_table_type;
        @BindView(R2.id.tlv_table_type)
        TriangleLabelView tlv_table_type;
        @BindView(R2.id.tv_type_labe)
        TextView tv_type_labe;


        public ViewHolder(View itemView) {
            super(itemView);
            ButterKnife.bind(this, itemView);
        }

        public TextView getTvName() {
            return tv_table;
        }

        public TextView getTvServiceFee() {
            return tv_service_fee;
        }

        public TableManagerItem getTableItem(int position) {
            TableManagerItem item = getSectionItem(position);
            return item;
        }

    }

}
