package com.gingersoft.gsa.cloud.scan.mvp.ui.activity;

import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.RadioGroup;

import androidx.annotation.Nullable;

import com.billy.cc.core.component.CC;
import com.billy.cc.core.component.CCResult;
import com.billy.cc.core.component.CCUtil;
import com.gingersoft.gsa.cloud.common.scan.ScanHelper;
import com.gingersoft.gsa.cloud.scan.R;
import com.gingersoft.gsa.cloud.scan.R2;
import com.xuexiang.rxutil2.rxjava.RxJavaUtils;

import java.util.ArrayList;

import butterknife.BindView;
import io.reactivex.functions.Consumer;

/**
 * 可選多次掃碼
 *
 * @author admin
 */
public class MultiScanCodeActivity extends MipcaCaptureActivity {
    @BindView(R2.id.rb_scan_type)
    RadioGroup mRbScanType;

    ArrayList<String> mScanValues;

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {
        super.initData(savedInstanceState);
        mRbScanType.setVisibility(View.VISIBLE);
    }

    @Override
    public void onScanQRCodeSuccess(String result) {
        //掃完一個碼後
        //將掃描內容存儲下來
        if (mRbScanType.getCheckedRadioButtonId() == R.id.rb_single_scan) {
            //單個掃碼
            vibrate();
            super.scanResult(result);
        } else {
            if (mScanValues == null) {
                mScanValues = new ArrayList<>();
            }
            if (!mScanValues.contains(result)) {
                vibrate();
                mScanValues.add(result);
                if (mScanValues.size() >= 10) {
                    scanResult("");
                }
                showMessage("掃描結果：" + result + "，已掃描" + mScanValues.size() + "個");
            } else {
                showMessage("SN碼已掃描，請更換SN碼");
            }
            mZXingView.stopSpot();
            //延遲一秒再啟動
            RxJavaUtils.delay(1, aLong -> mZXingView.startSpot());
        }
    }

    @Override
    protected void scanResult(String result) {
        Intent intent = new Intent();
        intent.putStringArrayListExtra(QR_RESULT_CODE, mScanValues);
        setResult(ScanHelper.CALL_BACK_QR_RESULT, intent);
        CC.sendCCResult(CCUtil.getNavigateCallId(this), CCResult.success(QR_RESULT_CODE, mScanValues));
        killMyself();
    }

}