package com.gingersoft.gsa.cloud.ui.adapter;

import android.graphics.Color;
import android.text.TextUtils;

import androidx.annotation.Nullable;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.pay.bean.PayMethod;
import com.gingersoft.gsa.cloud.ui.R;
import com.qmuiteam.qmui.alpha.QMUIAlphaTextView;

import java.util.List;

/**
 * Created by Wyh on 2020/1/17.
 */
public class BillMethodAdapter extends BaseQuickAdapter<PayMethod, BaseViewHolder> {

    public BillMethodAdapter(@Nullable List<PayMethod> data) {
        super(R.layout.item_bill_method, data);
    }

    @Override
    protected void convert(BaseViewHolder helper, PayMethod item) {
        QMUIAlphaTextView tv_bill_method_name = helper.getView(R.id.tv_bill_method_name);
        if (TextUtils.isEmpty(item.getPayName())) {
            tv_bill_method_name.setText(" ");
        } else {
            tv_bill_method_name.setText(item.getPayName());
        }
        tv_bill_method_name.setTextSize(item.getPayModeSize());
        if(!TextUtils.isEmpty(item.getFont_color())){
            tv_bill_method_name.setTextColor(Color.parseColor(item.getFont_color()));
        }
        if(!TextUtils.isEmpty(item.getColor())) {
            tv_bill_method_name.setBackgroundColor(Color.parseColor(item.getColor()));
        }
    }

}
