package com.gingersoft.gsa.cloud.main.mvp.ui.adapter;

import android.content.Context;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.gingersoft.gsa.cloud.main.R;
import com.gingersoft.gsa.cloud.main.mvp.model.bean.SalesReportBean;

import java.util.List;

import androidx.annotation.Nullable;

/**
 * Created by Wyh on 2020/2/24.
 */
public class FoodRankingAdapter extends BaseQuickAdapter<SalesReportBean.DataBean, BaseViewHolder> {

    private Context mContext;

    public FoodRankingAdapter(Context mContext, @Nullable List<SalesReportBean.DataBean> data) {
        super(R.layout.item_food_ranking, data);
        this.mContext = mContext;
    }

    @Override
    protected void convert(BaseViewHolder helper, SalesReportBean.DataBean item) {
        if (helper.getAdapterPosition() == 0) {
            helper.setTextColor(R.id.tv_ranking_foodname, mContext.getResources().getColor(R.color.theme_hint_color));
            helper.setTextColor(R.id.tv_ranking_food_sales_num, mContext.getResources().getColor(R.color.theme_hint_color));
            helper.setTextColor(R.id.tv_ranking_food_sales_amount, mContext.getResources().getColor(R.color.theme_hint_color));
            helper.setTextColor(R.id.tv_ranking_food_unit_price, mContext.getResources().getColor(R.color.theme_hint_color));
            helper.setTextColor(R.id.tv_ranking_proportion_quantity, mContext.getResources().getColor(R.color.theme_hint_color));
            helper.setTextColor(R.id.tv_ranking_ratio_amount, mContext.getResources().getColor(R.color.theme_hint_color));

            helper.setText(R.id.tv_ranking_food_unit_price, "食品名稱");
            helper.setText(R.id.tv_ranking_foodname, "銷售數量");
            helper.setText(R.id.tv_ranking_food_sales_num, "銷售金額");
            helper.setText(R.id.tv_ranking_food_sales_amount, "單價");
            helper.setText(R.id.tv_ranking_proportion_quantity, "數量佔比");
            helper.setText(R.id.tv_ranking_ratio_amount, "金額佔比");
        } else {
            helper.setTextColor(R.id.tv_ranking_foodname, mContext.getResources().getColor(R.color.color_8f));
            helper.setTextColor(R.id.tv_ranking_food_sales_num, mContext.getResources().getColor(R.color.color_3c));
            helper.setTextColor(R.id.tv_ranking_food_sales_amount, mContext.getResources().getColor(R.color.color_3c));
            helper.setTextColor(R.id.tv_ranking_food_unit_price, mContext.getResources().getColor(R.color.color_3c));
            helper.setTextColor(R.id.tv_ranking_proportion_quantity, mContext.getResources().getColor(R.color.color_3c));
            helper.setTextColor(R.id.tv_ranking_ratio_amount, mContext.getResources().getColor(R.color.color_3c));

            helper.setText(R.id.tv_ranking_food_unit_price, item.getAverageTotal() + "");
            helper.setText(R.id.tv_ranking_foodname, item.getFoodName());
            helper.setText(R.id.tv_ranking_food_sales_num, item.getSumNum() + "");
            helper.setText(R.id.tv_ranking_food_sales_amount, item.getSumTotal() + "");
            helper.setText(R.id.tv_ranking_proportion_quantity, item.getPercentageNum());
            helper.setText(R.id.tv_ranking_ratio_amount, item.getPercentageTotal());
        }
    }
}
