package com.gingersoft.gsa.cloud.main.mvp.ui.view;


import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.view.LayoutInflater;
import android.view.View;

import com.daivd.chart.data.BarData;
import com.daivd.chart.provider.component.mark.IMark;
import com.daivd.chart.provider.component.tip.MultiLineBubbleTip;
import com.daivd.chart.provider.component.tip.SingleLineBubbleTip;
import com.daivd.chart.utils.DensityUtils;
import com.gingersoft.gsa.cloud.main.R;

/**
 * Created by huang on 2017/9/28.
 */

public class CustomMarkView<C extends BarData> implements IMark<C> {

    private SingleLineBubbleTip<String> bubbleTip;
    private Paint paint;
    private View contentView;

    private MultiLineBubbleTip<View> multiLineBubbleTip;
//    private DialogUtils dialog;
    public CustomMarkView(Context context) {
        contentView = LayoutInflater.from(context).inflate(R.layout.layout_markview, null);

        paint = new Paint();
        paint.setAntiAlias(true);
        paint.setTextSize(DensityUtils.sp2px(context, 13));
        paint.setStyle(Paint.Style.FILL);
        paint.setColor(Color.WHITE);

        multiLineBubbleTip = new MultiLineBubbleTip<View>(context, R.drawable.bg,0, paint) {
            @Override
            public boolean isShowTip(View view, int position) {
                return true;
            }

            @Override
            public String[] format(View view, int position) {
                return new String[0];
            }
        };
        bubbleTip = new SingleLineBubbleTip<String>(context, R.drawable.bg, 0, paint) {

            @Override
            public boolean isShowTip(String s, int position) {
                return false;
            }

            @Override
            public String format(String s, int position) {
                return s;
            }
        };
        bubbleTip.setColorFilter(Color.parseColor("#F4A460"));
        bubbleTip.setAlpha(0.8f);
    }


    public Paint getPaint() {
        return paint;
    }

    @Override
    public void drawMark(Canvas canvas, float x, float y, Rect rect, String content, BarData data, int position) {
        String text = content + "---" + data.getChartYDataList().get(position) + "---" + data.getUnit();
//
//
        multiLineBubbleTip.drawTip(canvas, x, y, rect, contentView, position);
//        dialog.show();
    }
}
