package com.joe.print.mvp.ui.view;

import android.content.Context;
import android.graphics.Typeface;
import android.util.AttributeSet;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.Nullable;

import com.gingersoft.gsa.cloud.common.utils.other.TextUtil;
import com.gingersoft.gsa.cloud.database.bean.PrinterDeviceBean;
import com.gingersoft.gsa.cloud.print.bean.PrjBean;
import com.joe.print.R;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author 宇航.
 * User: admin
 * Date: 2021/1/20
 * Time: 14:45
 * Use:
 */
public class KitChenPrjFoodView extends LinearLayout {

    private int indentation = 0;

    private int foodFontSize = 24;
    private int modifierFontSize = 24;
    private int foodIsBold;
    private int modifierIsBold;
    private int foodIsItalic;
    private int modifierIsItalic;
    private String[] languageTypes;
    private List<PrjBean> data;

    public KitChenPrjFoodView(Context context, @Nullable List<PrjBean> data, PrinterDeviceBean printerDeviceBean) {
        super(context);
        try {
            this.foodFontSize = Integer.parseInt(printerDeviceBean.getFoodFont()) * 2;
            this.modifierFontSize = Integer.parseInt(printerDeviceBean.getModifierFont()) * 2;
        } catch (NumberFormatException e) {
            e.printStackTrace();
        }
        this.foodIsBold = printerDeviceBean.getFoodIsBold();
        this.modifierIsBold = printerDeviceBean.getModifierIsBold();
        this.foodIsItalic = printerDeviceBean.getFoodIsItalic();
        this.modifierIsItalic = printerDeviceBean.getModifierIsItalic();
        this.data = data;
        languageTypes = printerDeviceBean.getLanguageType().split(",");
        init();
    }

    private void init() {
        setOrientation(LinearLayout.VERTICAL);
        for (PrjBean item : data) {
//            View view = View.inflate(getContext(), R.layout.print_kitchen_item_parent, null);
//            LinearLayout layout = view.findViewById(R.id.layout_print_kitchen_parent);
            for (String type : languageTypes) {
                String languageType = type;
                if (languageType.contains(".")) {
                    languageType = type.substring(0, type.indexOf("."));
                }
                if (languageType.equals(PrinterDeviceBean.LANGUAGE_TWO)) {
                    //語言二
                    if (TextUtil.isNotEmptyOrNullOrUndefined(item.getProductName2())) {
                        addView(getOtherLanguageView(item.getItemType(), item.getProductName2(), item.getNumber()));
                    }
                } else if (languageType.equals(PrinterDeviceBean.LANGUAGE_THREE)) {
                    //語言三
                    if (TextUtil.isNotEmptyOrNullOrUndefined(item.getProductName3())) {
                        addView(getOtherLanguageView(item.getItemType(), item.getProductName3(), item.getNumber()));
                    }
                } else {
                    //語言一或其他
                    if (TextUtil.isNotEmptyOrNullOrUndefined(item.getProductName())) {
                        addView(getOtherLanguageView(item.getItemType(), item.getProductName(), item.getNumber()));
                    }
                }
            }
//            addView(view);
        }
    }

    private View getOtherLanguageView(int itemType, String foodName, int foodNumber) {
        View view = View.inflate(getContext(), R.layout.print_kitchen_item_food, null);
        TextView tvFoodName = view.findViewById(R.id.tv_food_name);
        TextView tvFoodNum = view.findViewById(R.id.tv_food_number);
        if (indentation == 0) {
            //只第一次測量一下
            indentation = BigDecimal.valueOf(tvFoodName.getPaint().measureText("哈")).setScale(0, BigDecimal.ROUND_HALF_UP).intValue();
        }
        boolean isBold, isItalic;
        int paddingLeft;
        if (itemType == PrjBean.FOOD_SECONDARY) {
            //細項，縮進
            paddingLeft = indentation;
            tvFoodName.setTextSize(modifierFontSize);
            tvFoodNum.setTextSize(modifierFontSize);

            isBold = modifierIsBold == 1;
            isItalic = modifierIsItalic == 1;
        } else if (itemType == PrjBean.FOOD_THREE_LEVEL) {
            //細項，縮進
            paddingLeft = indentation * 2;
            tvFoodName.setTextSize(modifierFontSize);
            tvFoodNum.setTextSize(modifierFontSize);

            isBold = modifierIsBold == 1;
            isItalic = modifierIsItalic == 1;
        } else {
            paddingLeft = 0;
            tvFoodName.setTextSize(foodFontSize);
            tvFoodNum.setTextSize(foodFontSize);

            isBold = foodIsBold == 1;
            isItalic = foodIsItalic == 1;
        }
        tvFoodName.setPadding(paddingLeft, tvFoodName.getPaddingTop(), tvFoodName.getPaddingRight(), tvFoodName.getPaddingBottom());
        tvFoodNum.setText(String.valueOf(foodNumber));
        tvFoodName.setText(foodName);

        if (isBold && isItalic) {
            tvFoodName.setTypeface(null, Typeface.BOLD_ITALIC);
            tvFoodNum.setTypeface(null, Typeface.BOLD_ITALIC);
        } else if (isBold) {
            tvFoodName.setTypeface(null, Typeface.BOLD);
            tvFoodNum.setTypeface(null, Typeface.BOLD);
        } else if (isItalic) {
            tvFoodName.setTypeface(null, Typeface.ITALIC);
            tvFoodNum.setTypeface(null, Typeface.ITALIC);
        } else {
            tvFoodName.setTypeface(null, Typeface.NORMAL);
            tvFoodNum.setTypeface(null, Typeface.NORMAL);
        }
        return view;
    }

}
