package com.gingersoft.gsa.cloud.table.mvp.presenter.discount;

import android.app.Application;

import com.gingersoft.gsa.cloud.common.core.discount.MemberCoupon;
import com.gingersoft.gsa.cloud.common.core.member.MemberInfo;
import com.gingersoft.gsa.cloud.common.core.restaurant.RestaurantInfoManager;
import com.gingersoft.gsa.cloud.common.loadsir.EmptyCallback;
import com.gingersoft.gsa.cloud.common.utils.JsonUtils;
import com.gingersoft.gsa.cloud.order.order.DoshokuOrder;
import com.gingersoft.gsa.cloud.common.rxjava.ErrorHandleSingleSubscriber;
import com.gingersoft.gsa.cloud.table.mvp.model.bean.response.OrderManagerResponse;
import com.jess.arms.integration.AppManager;
import com.jess.arms.di.scope.FragmentScope;
import com.jess.arms.mvp.BasePresenter;
import com.jess.arms.http.imageloader.ImageLoader;

import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.schedulers.Schedulers;
import me.jessyan.rxerrorhandler.core.RxErrorHandler;

import javax.inject.Inject;

import com.gingersoft.gsa.cloud.table.mvp.contract.CouponContract;
import com.jess.arms.utils.RxLifecycleUtils;
import com.scwang.smartrefresh.layout.api.RefreshLayout;

import java.util.List;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 04/02/2021 17:28
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@FragmentScope
public class CouponPresenter extends BasePresenter<CouponContract.Model, CouponContract.View> {
    @Inject
    RxErrorHandler mErrorHandler;
    @Inject
    Application mApplication;
    @Inject
    ImageLoader mImageLoader;
    @Inject
    AppManager mAppManager;

    //是否可以繼續上拉刷新
    private boolean noMoreData = false;
    /**
     * 0=沒有限制
     * 1=食品專有
     * 2=帳單專有
     */
    private int limitType = 0;
    private int pageIndex = 1;
    private int pageSize = 20;

    @Inject
    public CouponPresenter(CouponContract.Model model, CouponContract.View rootView) {
        super(model, rootView);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mErrorHandler = null;
        this.mAppManager = null;
        this.mImageLoader = null;
        this.mApplication = null;
    }

    public void getMemberWalletList(RefreshLayout refreshLayout, boolean isLoadMore) {
        int brandId = RestaurantInfoManager.newInstance().getBrandId();
        MemberInfo memberInfo = DoshokuOrder.getInstance().getMemberInfo();
        long memberId = 0;
        if (memberInfo != null) {
            memberId = memberInfo.getId();
        }
        mModel.getMemberWalletList(brandId, memberId, limitType, pageIndex, pageSize)
                .subscribeOn(Schedulers.io())
                .doOnSubscribe(disposable -> {
                            if (refreshLayout == null) {
                                mRootView.showLoading(null);
                            }
                        }
                )
                .subscribeOn(AndroidSchedulers.mainThread())
                .observeOn(AndroidSchedulers.mainThread())
                .doAfterTerminate(() -> mRootView.hideLoading())
                .compose(RxLifecycleUtils.bindToLifecycle(mRootView))
                .subscribe(new ErrorHandleSingleSubscriber<List<MemberCoupon>>(mErrorHandler, mRootView.getLoadService()) {

                    @Override
                    public void onSuccess(List<MemberCoupon> result) {
                        if (pageIndex != 0) {
                            //根據數據庫下標分頁
                            pageIndex = pageIndex * pageSize;
                        }
                        if (result.size() > 0) {
                            if (!noMoreData) {
                                mRootView.returnMemberCouponList(result);
                                mRootView.showLoadSirSuccess();
                            }
                            if (result.size() < pageSize) {
                                //沒有更多數據不能上拉刷新
                                noMoreData = true;
                            } else {
                                noMoreData = false;
                            }
                        } else {
                            if (!noMoreData) {
                                mRootView.showLoadSirCall(EmptyCallback.class);
                            }
                        }
                        resetRefreshLayout(noMoreData);
                    }

                    @Override
                    public void onError(Throwable t) {
                        if (pageIndex != 0) {
                            //根據數據庫下標分頁
                            pageIndex = pageIndex * pageSize;
                        }
                        resetRefreshLayout(false);
                    }

                    private void resetRefreshLayout(boolean noMoreData) {
                        if (refreshLayout != null) {
                            if (isLoadMore) {
                                if (noMoreData) {
                                    refreshLayout.setNoMoreData(true);
                                }
                                refreshLayout.finishLoadMore();
                            } else {
                                refreshLayout.finishRefresh();
                                refreshLayout.resetNoMoreData();
                            }
                        }
                    }
                });
    }
}
