package com.gingersoft.gsa.cloud.table.mvp.ui.fragment.mealstand;

import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.viewpager.widget.ViewPager;
import androidx.viewpager2.widget.ViewPager2;

import com.gingersoft.gsa.cloud.common.core.member.MemberInfo;
import com.gingersoft.gsa.cloud.order.order.DoshokuOrder;
import com.gingersoft.gsa.cloud.table.R;
import com.gingersoft.gsa.cloud.table.mvp.contract.MealDiscountContract;
import com.gingersoft.gsa.cloud.table.mvp.presenter.mealstand.MealDiscountPresenter;
import com.gingersoft.gsa.cloud.table.mvp.ui.fragment.discount.CouponFragment;
import com.gingersoft.gsa.cloud.table.mvp.ui.fragment.discount.NomalDiscountFragment;
import com.gingersoft.gsa.cloud.ui.adapter.TabFragmentAdapter;
import com.gingersoft.gsa.cloud.ui.view.MyTableView;
import com.google.android.material.tabs.TabLayout;
import com.jess.arms.base.BaseFragment;
import com.jess.arms.di.component.AppComponent;
import com.jess.arms.utils.ArmsUtils;
import com.qmuiteam.qmui.widget.tab.QMUITab;

import java.util.ArrayList;
import java.util.List;

import javax.inject.Inject;

import butterknife.BindView;

import static com.jess.arms.utils.Preconditions.checkNotNull;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 04/17/2021 10:46
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
public class MealDiscountFragment extends BaseFragment<MealDiscountPresenter> implements MealDiscountContract.View {

    @BindView(R.id.tab_segment)
    MyTableView tabSegment;
    @BindView(R.id.viewPager)
    ViewPager viewPager;

    @Inject
    List<String> mTabTitles;


    public static MealDiscountFragment newInstance() {
        MealDiscountFragment fragment = new MealDiscountFragment();
        return fragment;
    }

    @Override
    public void setupFragmentComponent(@NonNull AppComponent appComponent) {
        DaggerMealDiscountComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .view(this)
                .build()
                .inject(this);
    }

    @Override
    public View initView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_meal_discount, container, false);
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {

        initTabTitles();
        initViewPager();
    }

    private void initTabTitles() {
        mTabTitles.add("折扣");
        MemberInfo memberInfo = DoshokuOrder.getInstance().getMemberInfo();
        if (memberInfo != null) {
            mTabTitles.add("優惠券");
        }
        tabSegment.setTitles(mTabTitles);
    }

    private void initViewPager() {

        List<Fragment> mFragments = new ArrayList<>();
        mFragments.add(NomalDiscountFragment.newInstance());
        mFragments.add(CouponFragment.newInstance());

        //实例化适配器
        TabFragmentAdapter mTabFragmentAdapter = new TabFragmentAdapter(getParentFragmentManager(), 1);
        //设置加载的Fragment集合
        mTabFragmentAdapter.setFragments(mFragments);
        //设置Viewpager的适配器
        viewPager.setAdapter(mTabFragmentAdapter);
        //TabLayout绑定ViewPager
        tabSegment.setTitles(mTabTitles).setupWithViewPager(viewPager);
    }

    @Override
    public void setData(@Nullable Object data) {

    }

    @Override
    public void showLoading(String message) {

    }

    @Override
    public void hideLoading() {

    }

    @Override
    public void showMessage(@NonNull String message) {
        checkNotNull(message);
        ArmsUtils.snackbarText(message);
    }

    @Override
    public void launchActivity(@NonNull Intent intent) {
        checkNotNull(intent);
        ArmsUtils.startActivity(intent);
    }

    @Override
    public void killMyself() {

    }
}
